/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.cyclos.utils.HasPartialData;

public class SerializableInputStream
extends InputStream
implements Serializable,
HasPartialData {
    private static Supplier<File> tempFileSupplier = () -> {
        try {
            return File.createTempFile("cyclos", "data");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    };
    private static final int BUFFER_SIZE = 10240;
    private static final long serialVersionUID = 2L;
    private transient InputStream inputStream;
    private transient byte[] bytes;
    private transient File file;
    private transient boolean keepFile;
    private transient boolean streamClosed;
    private boolean partialData;

    public static void setTempFileSupplier(Supplier<File> supplier) {
        tempFileSupplier = supplier;
    }

    public SerializableInputStream(Blob blob) throws IOException {
        try {
            this.inputStream = blob.getBinaryStream();
            this.streamClosed = false;
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException(sQLException);
        }
        this.forceCopyToFile();
    }

    public SerializableInputStream(byte[] byArray) {
        this.bytes = byArray;
        this.streamClosed = true;
    }

    public SerializableInputStream(File file) {
        this.file = file;
        this.streamClosed = true;
    }

    public SerializableInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.streamClosed = false;
    }

    @Override
    public int available() throws IOException {
        this.checkOpen(true);
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        try {
            this.closeStream();
        }
        finally {
            if (this.file != null && !this.keepFile) {
                this.file.delete();
                this.file = null;
            }
        }
    }

    public File file() throws IOException, IllegalStateException {
        if (this.streamClosed && this.file == null && this.bytes == null) {
            throw new IllegalStateException("Already closed");
        }
        if (this.file == null) {
            this.forceCopyToFile();
        }
        this.keepFile = true;
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] forceCopyToBytes() throws IOException {
        if (this.bytes == null) {
            try (InputStream inputStream = this.inputStream();){
                this.bytes = IOUtils.toByteArray((InputStream)inputStream);
            }
            finally {
                this.close();
            }
        }
        return this.bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File forceCopyToFile() throws IOException {
        if (this.file == null) {
            this.file = tempFileSupplier.get();
            try (InputStream inputStream = this.inputStream();
                 FileOutputStream fileOutputStream = new FileOutputStream(this.file);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
            }
            finally {
                this.closeStream();
            }
        }
        return this.file;
    }

    @Override
    public boolean isPartialData() {
        return this.partialData;
    }

    public boolean isStreamClosed() {
        return this.streamClosed;
    }

    @Override
    public int read() throws IOException {
        this.checkOpen(true);
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        this.checkOpen(true);
        return this.inputStream.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkOpen(true);
        return this.inputStream.read(byArray, n, n2);
    }

    public void reOpen() throws IOException {
        if (this.file == null && this.bytes == null) {
            throw new IOException("Stream already closed without a copy to file or byte[]");
        }
        this.closeStream();
        this.checkOpen(true);
    }

    public void setPartialData(boolean bl) {
        this.partialData = bl;
    }

    private boolean canBeRead() {
        return !this.streamClosed || this.file != null || this.bytes != null;
    }

    private void checkOpen(boolean bl) throws IOException {
        if (!this.canBeRead()) {
            throw new IOException(SerializableInputStream.class.getSimpleName() + " is already closed");
        }
        if (bl && this.streamClosed) {
            this.inputStream = this.inputStream();
            this.streamClosed = false;
        }
    }

    private void closeStream() throws IOException {
        if (this.streamClosed) {
            return;
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        finally {
            this.inputStream = null;
            this.streamClosed = true;
        }
    }

    private InputStream inputStream() throws IOException {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.bytes != null) {
            return new ByteArrayInputStream(this.bytes);
        }
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        throw new IllegalStateException("Already closed");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        if (n < 10240) {
            this.bytes = objectInputStream.readNBytes(n);
            this.inputStream = new ByteArrayInputStream(this.bytes);
        } else {
            this.file = tempFileSupplier.get();
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.file);){
                while (n > 0) {
                    int n2 = Math.min(n, 10240);
                    fileOutputStream.write(objectInputStream.readNBytes(n2));
                    n -= n2;
                }
            }
            this.inputStream = new FileInputStream(this.file);
            this.keepFile = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        block10: {
            try {
                if (!this.canBeRead()) {
                    objectOutputStream.writeInt(0);
                    break block10;
                }
                if (this.bytes != null) {
                    objectOutputStream.writeInt(this.bytes.length);
                    objectOutputStream.write(this.bytes);
                    break block10;
                }
                File file = this.file == null ? this.forceCopyToFile() : this.file;
                objectOutputStream.writeInt((int)file.length());
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)objectOutputStream);
                }
            }
            finally {
                this.close();
            }
        }
    }
}

