/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cyclos.model.access.AccessSubmodule;
import org.cyclos.model.app.AppSubmodule;
import org.cyclos.model.banking.BankingSubmodule;
import org.cyclos.model.contentmanagement.ContentManagementSubmodule;
import org.cyclos.model.general.GeneralSubmodule;
import org.cyclos.model.marketplace.MarketplaceSubmodule;
import org.cyclos.model.messaging.MessagingSubmodule;
import org.cyclos.model.mobile.MobileSubmodule;
import org.cyclos.model.system.SystemSubmodule;
import org.cyclos.model.users.UsersSubmodule;
import org.cyclos.utils.Module;
import org.cyclos.utils.PrefixedEnum;
import org.cyclos.utils.Submodule;

public class Submodules {
    private static final Map<Module, Class<? extends Submodule>> SUBMODULE_BY_MODULE;
    private static final Map<Submodule, Integer> SUBMODULE_IDS;
    private static final Map<String, Class<? extends PrefixedEnum>> PREFIX_MAPPING;

    public static Submodule aggregate(Set<Submodule> set) {
        return new AggregatedSubmodules(set);
    }

    public static Submodule aggregate(Submodule ... submoduleArray) {
        return Submodules.aggregate(new HashSet<Submodule>(Arrays.asList(submoduleArray)));
    }

    public static Set<Submodule> flatten(Submodule submodule) {
        if (submodule == null) {
            return Collections.emptySet();
        }
        if (submodule instanceof AggregatedSubmodules) {
            return ((AggregatedSubmodules)submodule).submodules;
        }
        return Collections.singleton(submodule);
    }

    public static Submodule from(String string) {
        int n = string.indexOf(46);
        if (n < 0) {
            throw new IllegalArgumentException("Invalid submodule string: " + string);
        }
        String string2 = string.substring(0, n).toUpperCase();
        Module module = Module.valueOf(string2);
        Class<? extends Submodule> clazz = SUBMODULE_BY_MODULE.get((Object)module);
        if (clazz == null) {
            throw new IllegalArgumentException("Invalid module: " + String.valueOf((Object)module));
        }
        String string3 = string.substring(n + 1).toUpperCase();
        Class<? extends Submodule> clazz2 = clazz;
        try {
            Submodule submodule = Enum.valueOf(clazz2, string3);
            return submodule;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("No submodule '" + string3 + "' found on module '" + String.valueOf((Object)module) + "'");
        }
    }

    public static Submodule fromKey(String string) {
        int n = string.indexOf(46);
        if (n < 0) {
            throw new IllegalArgumentException("Invalid submodule string: " + string);
        }
        int n2 = string.indexOf(46, n + 1);
        String string2 = string.substring(0, n2);
        return Submodules.from(string2);
    }

    public static int getId(Submodule submodule) {
        Integer n = SUBMODULE_IDS.get(submodule);
        if (n == null) {
            throw new IllegalStateException("Unhandled submodule id for " + String.valueOf(submodule));
        }
        return n;
    }

    public static Map<String, Class<? extends PrefixedEnum>> getPrefixMapping() {
        return PREFIX_MAPPING;
    }

    public static Class<? extends Submodule> getSubmoduleClassFor(Module module) {
        return SUBMODULE_BY_MODULE.get((Object)module);
    }

    public static List<? extends Submodule> getSubmodulesFromModule(Module module) {
        Class<? extends Submodule> clazz = SUBMODULE_BY_MODULE.get((Object)module);
        if (clazz != null) {
            return Arrays.asList(clazz.getEnumConstants());
        }
        return null;
    }

    public static String qualifiedName(Submodule submodule) {
        return submodule == null ? null : submodule.module().name() + "." + submodule.name();
    }

    static {
        HashMap<Module, Class> hashMap = new HashMap<Module, Class>();
        hashMap.put(Module.ACCESS, AccessSubmodule.class);
        hashMap.put(Module.APP, AppSubmodule.class);
        hashMap.put(Module.BANKING, BankingSubmodule.class);
        hashMap.put(Module.CONTENT_MANAGEMENT, ContentManagementSubmodule.class);
        hashMap.put(Module.GENERAL, GeneralSubmodule.class);
        hashMap.put(Module.MARKETPLACE, MarketplaceSubmodule.class);
        hashMap.put(Module.MESSAGING, MessagingSubmodule.class);
        hashMap.put(Module.MOBILE, MobileSubmodule.class);
        hashMap.put(Module.SYSTEM, SystemSubmodule.class);
        hashMap.put(Module.USERS, UsersSubmodule.class);
        SUBMODULE_BY_MODULE = Collections.unmodifiableMap(hashMap);
        HashMap<String, Class> hashMap2 = new HashMap<String, Class>();
        for (Map.Entry object2 : hashMap.entrySet()) {
            hashMap2.put(((Module)((Object)object2.getKey())).name(), (Class)object2.getValue());
        }
        PREFIX_MAPPING = Collections.unmodifiableMap(hashMap2);
        int n = 0;
        HashMap<Submodule, Integer> hashMap3 = new HashMap<Submodule, Integer>();
        for (Module module : Module.values()) {
            List<? extends Submodule> list = Submodules.getSubmodulesFromModule(module);
            for (Submodule submodule : list) {
                hashMap3.put(submodule, n++);
            }
        }
        SUBMODULE_IDS = Collections.unmodifiableMap(hashMap3);
        if (hashMap.size() != Module.values().length) {
            throw new IllegalStateException("Please check Submodules helper class: there are modules not added to this helper.");
        }
    }

    private static class AggregatedSubmodules
    implements Submodule {
        private final Set<Submodule> submodules;

        public AggregatedSubmodules(Set<Submodule> set) {
            this.submodules = set;
        }

        @Override
        public Module module() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String prefix() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.submodules == null ? "<null submodules>" : this.submodules.toString();
        }
    }
}

