/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model;

import java.util.List;
import org.cyclos.model.BasicProperty;
import org.cyclos.model.Bean;
import org.cyclos.model.Property;
import org.cyclos.utils.GwtIncompatible;

public abstract class QueryParameters
extends Bean {
    private static final long serialVersionUID = 1L;
    public static final Property<Integer, QueryParameters> CURRENT_PAGE = new BasicProperty<Integer, QueryParameters>("currentPage", Integer.class, "java.lang.Integer", QueryParameters.class, null, null);
    public static final Property<Integer, QueryParameters> PAGE_SIZE = new BasicProperty<Integer, QueryParameters>("pageSize", Integer.class, "java.lang.Integer", QueryParameters.class, null, null);
    public static final Property<Boolean, QueryParameters> SKIP_TOTAL_COUNT = new BasicProperty<Boolean, QueryParameters>("skipTotalCount", Boolean.TYPE, "boolean", QueryParameters.class, null, null, false);

    public Integer getCurrentPage() {
        return this.get(CURRENT_PAGE);
    }

    public Integer getPageSize() {
        return this.get(PAGE_SIZE);
    }

    public boolean isSkipTotalCount() {
        return Boolean.TRUE.equals(this.get(SKIP_TOTAL_COUNT));
    }

    public void setCountOnly() {
        this.setCurrentPage(0);
        this.setPageSize(0);
    }

    public void setCurrentPage(Integer n) {
        this.set(CURRENT_PAGE, n);
    }

    public void setPageSize(Integer n) {
        this.set(PAGE_SIZE, n);
    }

    public void setSkipTotalCount(boolean bl) {
        this.set(SKIP_TOTAL_COUNT, bl);
    }

    @GwtIncompatible
    public void setUnlimited() {
        this.setCurrentPage(0);
        this.setPageSize(Integer.MAX_VALUE);
    }

    public void useMaxAllowedPagination(int n) {
        this.setCurrentPage(n);
        this.setPageSize(Integer.MAX_VALUE);
    }

    @Override
    protected List<Property<?, ?>> doGetProperties() {
        List<Property<?, ?>> list = super.doGetProperties();
        list.add(CURRENT_PAGE);
        list.add(PAGE_SIZE);
        return list;
    }
}

