/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cyclos.model.Bean;
import org.cyclos.model.Property;

public final class NestedProperty<T, B extends Bean>
extends Property<T, B> {
    private static final long serialVersionUID = 1L;
    private List<Property<?, ?>> path;

    public static NestedProperty<?, ?> nested(Property<?, ?> ... propertyArray) {
        return new NestedProperty(propertyArray);
    }

    public static <T, B extends Bean> NestedProperty<T, B> nested(Property<?, B> property, Property<?, ?> property2, Property<T, ?> property3) {
        return new NestedProperty<T, B>(property, property2, property3);
    }

    public static <T, B extends Bean> NestedProperty<T, B> nested(Property<?, B> property, Property<T, ?> property2) {
        return new NestedProperty<T, B>(property, property2);
    }

    private static String getName(Property<?, ?> ... propertyArray) {
        if (propertyArray == null || propertyArray.length == 0) {
            throw new IllegalArgumentException("Empty nested properties!");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Property<?, ?> property : propertyArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(property.getName());
        }
        return stringBuilder.toString();
    }

    private static List<Property<?, ?>> getPath(Property<?, ?> ... propertyArray) {
        return Arrays.asList(propertyArray);
    }

    private NestedProperty(Property<?, ?> ... propertyArray) {
        super(NestedProperty.getName(propertyArray), propertyArray[propertyArray.length - 1].getType(), propertyArray[propertyArray.length - 1].getTypeName(), propertyArray[0].getBeanType(), propertyArray[propertyArray.length - 1].getTextMode(), propertyArray[propertyArray.length - 1].getTrimMode());
        this.path = NestedProperty.getPath(propertyArray);
    }

    private NestedProperty(Property<?, B> property, Property<?, ?> property2, Property<T, ?> property3) {
        super(NestedProperty.getName(property, property2, property3), property3.getType(), property3.getTypeName(), property.getBeanType(), property3.getTextMode(), property3.getTrimMode());
        this.path = NestedProperty.getPath(property, property2, property3);
    }

    private NestedProperty(Property<?, B> property, Property<T, ?> property2) {
        super(NestedProperty.getName(property, property2), property2.getType(), property2.getTypeName(), property.getBeanType(), property2.getTextMode(), property2.getTrimMode());
        this.path = NestedProperty.getPath(property, property2);
    }

    public List<Property<?, ?>> getPath() {
        return Collections.unmodifiableList(this.path);
    }
}

