/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;

public class TranslationMessageSpecification
implements Serializable {
    private static final long serialVersionUID = 1L;
    private MessageFormat format;
    private MessageKey key;
    private Object[] arguments;

    public TranslationMessageSpecification() {
    }

    public TranslationMessageSpecification(MessageFormat messageFormat, MessageKey messageKey) {
        this.format = messageFormat;
        this.key = messageKey;
    }

    public TranslationMessageSpecification(MessageFormat messageFormat, MessageKey messageKey, List<?> list) {
        this(messageFormat, messageKey, CollectionHelper.isEmpty(list) ? (Object[])null : list.toArray());
    }

    public TranslationMessageSpecification(MessageFormat messageFormat, MessageKey messageKey, Object ... objectArray) {
        this.format = messageFormat;
        this.key = messageKey;
        this.arguments = objectArray;
    }

    public TranslationMessageSpecification(MessageKey messageKey) {
        this.key = messageKey;
    }

    public TranslationMessageSpecification(MessageKey messageKey, List<?> list) {
        this(messageKey, CollectionHelper.isEmpty(list) ? (Object[])null : list.toArray());
    }

    public TranslationMessageSpecification(MessageKey messageKey, Object ... objectArray) {
        this.key = messageKey;
        this.arguments = objectArray;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public MessageFormat getFormat() {
        return this.format;
    }

    public MessageKey getKey() {
        return this.key;
    }

    public void setArguments(Object[] objectArray) {
        this.arguments = objectArray;
    }

    public void setFormat(MessageFormat messageFormat) {
        this.format = messageFormat;
    }

    public void setKey(MessageKey messageKey) {
        this.key = messageKey;
    }

    public String toString() {
        if (CollectionHelper.isEmpty((Object[])this.arguments)) {
            return this.key.toString();
        }
        return String.valueOf(this.key) + "%" + String.valueOf(Arrays.asList(this.arguments));
    }
}

