/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import java.util.Arrays;
import java.util.List;

public enum ContentType {
    TEXT(false),
    HTML(false),
    XML(false),
    CSS(false),
    JSON(false),
    YAML(false),
    JAVASCRIPT(false),
    CSV(false),
    JPEG(true),
    GIF(true),
    PNG(true),
    WEBP(true),
    PDF(true),
    ZIP(true),
    SVG(false),
    TTF(false),
    OTF(true),
    WOFF(true),
    WOFF2(true),
    EOT(true),
    BIN(true);

    public static final int MIN_GZIP_LENGTH = 9;
    private List<String> mimeTypes;
    private List<String> extensions;
    private final boolean binary;

    public static ContentType getByExtension(String string) {
        if (string == null) {
            return null;
        }
        string = string.toLowerCase();
        for (ContentType contentType : ContentType.values()) {
            if (!contentType.extensions.contains(string)) continue;
            return contentType;
        }
        return null;
    }

    public static ContentType getByFileName(String string) {
        try {
            int n = string.lastIndexOf(46);
            return ContentType.getByExtension(string.substring(n + 1));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ContentType getByMimeType(String string) {
        if (string == null) {
            return null;
        }
        string = string.toLowerCase();
        for (ContentType contentType : ContentType.values()) {
            if (!contentType.mimeTypes.contains(string)) continue;
            return contentType;
        }
        return null;
    }

    private ContentType(boolean bl) {
        this.binary = bl;
    }

    public String getExtension() {
        return this.extensions.get(0);
    }

    public String getMimeType() {
        return this.mimeTypes.get(0);
    }

    public boolean isBinary() {
        return this.binary;
    }

    private void setExtensions(String ... stringArray) {
        this.extensions = Arrays.asList(stringArray);
    }

    private void setMimeTypes(String ... stringArray) {
        this.mimeTypes = Arrays.asList(stringArray);
    }

    static {
        TEXT.setMimeTypes("text/plain");
        TEXT.setExtensions("txt", "text");
        HTML.setMimeTypes("text/html");
        HTML.setExtensions("html", "htm");
        XML.setMimeTypes("text/xml", "application/xml");
        XML.setExtensions("XML");
        CSS.setMimeTypes("text/css");
        CSS.setExtensions("css");
        JSON.setMimeTypes("application/json");
        JSON.setExtensions("json", "map");
        YAML.setMimeTypes("text/yaml", "application/yaml", "application/x-yaml", "text/x-yaml");
        YAML.setExtensions("yaml", "yml");
        JAVASCRIPT.setMimeTypes("text/javascript", "application/javascript", "application/x-javascript");
        JAVASCRIPT.setExtensions("js");
        CSV.setMimeTypes("text/csv");
        CSV.setExtensions("csv");
        JPEG.setMimeTypes("image/jpeg", "image/jpg", "image/pjpeg");
        JPEG.setExtensions("jpg", "jpeg");
        GIF.setMimeTypes("image/gif");
        GIF.setExtensions("gif");
        PNG.setMimeTypes("image/png", "image/x-png");
        PNG.setExtensions("png");
        WEBP.setMimeTypes("image/webp");
        WEBP.setExtensions("webp");
        PDF.setMimeTypes("application/pdf");
        PDF.setExtensions("pdf");
        ZIP.setMimeTypes("application/zip", "application/x-zip");
        ZIP.setExtensions("zip");
        SVG.setMimeTypes("image/svg+xml");
        SVG.setExtensions("svg");
        TTF.setMimeTypes("application/font-sfnt", "application/x-font-ttf", "application/x-font-truetype");
        TTF.setExtensions("ttf");
        OTF.setMimeTypes("application/font-sfnt", "application/x-font-opentype");
        OTF.setExtensions("otf");
        WOFF.setMimeTypes("application/font-woff");
        WOFF.setExtensions("woff");
        WOFF2.setMimeTypes("application/font-woff2");
        WOFF2.setExtensions("woff2");
        EOT.setMimeTypes("application/vnd.ms-fontobject");
        EOT.setExtensions("eot");
        BIN.setMimeTypes("application/octet-stream");
        BIN.setExtensions("bin");
    }
}

