/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import org.cyclos.utils.StringHelper;

public class ColorHelper {
    private static final int[] YIQ_DARK_TEXT = ColorHelper.parse("#212529");
    private static final int[] YIQ_LIGHT_TEXT = ColorHelper.parse("#ffffff");

    public static int[] colorYiq(int[] nArray) {
        return ColorHelper.colorYiq(nArray, YIQ_DARK_TEXT, YIQ_LIGHT_TEXT);
    }

    public static int[] colorYiq(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int n2;
        int n3 = Math.max(0, Math.min(255, nArray[0]));
        float f = (float)(n3 * 299 + (n2 = Math.max(0, Math.min(255, nArray[1]))) * 587 + (n = Math.max(0, Math.min(255, nArray[2]))) * 114) / 1000.0f;
        return f >= 150.0f ? nArray2 : nArray3;
    }

    public static String formatRGBasHex(int ... nArray) {
        if (nArray == null || nArray.length != 3) {
            return null;
        }
        return "#" + ColorHelper.toHexPart(nArray[0]) + ColorHelper.toHexPart(nArray[1]) + ColorHelper.toHexPart(nArray[2]);
    }

    public static int[] fromHSVtoRGB(int n, int n2, int n3) {
        float f;
        float f2;
        float f3;
        n = Math.max(0, Math.min(360, n));
        n2 = Math.max(0, Math.min(100, n2));
        n3 = Math.max(0, Math.min(100, n3));
        float f4 = (float)n2 / 100.0f;
        float f5 = (float)n3 / 100.0f;
        if (f4 == 0.0f) {
            int n4 = Math.round(f5 * 255.0f);
            return ColorHelper.toArray(n4, n4, n4);
        }
        float f6 = n;
        int n5 = (int)Math.floor(f6 /= 60.0f);
        float f7 = f6 - (float)n5;
        float f8 = f5 * (1.0f - f4);
        float f9 = f5 * (1.0f - f4 * f7);
        float f10 = f5 * (1.0f - f4 * (1.0f - f7));
        switch (n5) {
            case 0: {
                f3 = f5;
                f2 = f10;
                f = f8;
                break;
            }
            case 1: {
                f3 = f9;
                f2 = f5;
                f = f8;
                break;
            }
            case 2: {
                f3 = f8;
                f2 = f5;
                f = f10;
                break;
            }
            case 3: {
                f3 = f8;
                f2 = f9;
                f = f5;
                break;
            }
            case 4: {
                f3 = f10;
                f2 = f8;
                f = f5;
                break;
            }
            default: {
                f3 = f5;
                f2 = f8;
                f = f9;
            }
        }
        int n6 = Math.round(f3 * 255.0f);
        int n7 = Math.round(f2 * 255.0f);
        int n8 = Math.round(f * 255.0f);
        return new int[]{n6, n7, n8};
    }

    public static int[] fromHSVtoRGB(int[] nArray) {
        return nArray == null ? null : ColorHelper.fromHSVtoRGB(nArray[0], nArray[1], nArray[2]);
    }

    public static int[] fromRGB(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        return ColorHelper.toArray(n2, n3, n4);
    }

    public static int[] fromRGBtoHSV(int n, int n2, int n3) {
        n = Math.max(0, Math.min(255, n));
        n2 = Math.max(0, Math.min(255, n2));
        n3 = Math.max(0, Math.min(255, n3));
        int n4 = Math.min(Math.min(n, n2), n3);
        int n5 = Math.max(Math.max(n, n2), n3);
        int n6 = n5 - n4;
        int n7 = Math.round((float)n5 / 255.0f * 100.0f);
        int n8 = Math.round((float)n6 / (float)n5 * 100.0f);
        if (n8 == 0 || n7 == 0) {
            return new int[]{0, n8, n7};
        }
        float f = n == n5 ? ((float)n2 - (float)n3) / (float)n6 : (n2 == n5 ? 2.0f + ((float)n3 - (float)n) / (float)n6 : 4.0f + ((float)n - (float)n2) / (float)n6);
        if ((f *= 60.0f) < 0.0f) {
            f += 360.0f;
        }
        return new int[]{Math.round(f), n8, n7};
    }

    public static int[] fromRGBtoHSV(int[] nArray) {
        return nArray == null ? null : ColorHelper.fromRGBtoHSV(nArray[0], nArray[1], nArray[2]);
    }

    public static int[] parse(String string) {
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        if (string.contains("(")) {
            return ColorHelper.parseRGB(string);
        }
        if (string.contains("#")) {
            return ColorHelper.parseRGBfromHex(string);
        }
        return ColorHelper.fromRGB(Integer.parseInt(string));
    }

    public static int[] parseRGB(String string) {
        if ((string = StringHelper.trim((Object)string).toLowerCase()).length() == 0) {
            return null;
        }
        int n = string.indexOf(40);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if (string.endsWith("")) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            String[] stringArray = string.split(",");
            int n2 = Integer.parseInt(StringHelper.trim((Object)stringArray[0]));
            int n3 = Integer.parseInt(StringHelper.trim((Object)stringArray[1]));
            int n4 = Integer.parseInt(StringHelper.trim((Object)stringArray[2]));
            return ColorHelper.toArray(n2, n3, n4);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid color: " + string);
        }
    }

    public static int[] parseRGBfromHex(String string) {
        if ((string = StringHelper.trim((Object)string).toLowerCase()).length() == 0) {
            return null;
        }
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        try {
            int n = Integer.parseInt(string.substring(0, 2), 16);
            int n2 = Integer.parseInt(string.substring(2, 4), 16);
            int n3 = Integer.parseInt(string.substring(4, 6), 16);
            return ColorHelper.toArray(n, n2, n3);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid color: " + string);
        }
    }

    public static int toRGB(int[] nArray) {
        if (nArray == null || nArray.length != 3) {
            return -1;
        }
        return (nArray[0] & 0xFF) << 16 | (nArray[1] & 0xFF) << 8 | (nArray[2] & 0xFF) << 0;
    }

    private static int[] toArray(int n, int n2, int n3) {
        return new int[]{n, n2, n3};
    }

    private static String toHexPart(int n) {
        Object object = Integer.toString(n, 16);
        if (((String)object).length() == 1) {
            object = "0" + (String)object;
        }
        return object;
    }
}

