/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cyclos.model.Property;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.addresses.AddressConfigurationData;
import org.cyclos.model.users.addresses.AddressDTO;
import org.cyclos.model.users.addresses.AddressFields;
import org.cyclos.model.users.addresses.AddressVO;
import org.cyclos.model.users.addresses.IAddress;
import org.cyclos.model.utils.DistanceUnit;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.StringHelper;

public class AddressHelper {
    public static double distance(double d, double d2, double d3, double d4, DistanceUnit distanceUnit) {
        if (d == d3 && d2 == d4) {
            return 0.0;
        }
        double d5 = Math.PI * d / 180.0;
        double d6 = Math.PI * d3 / 180.0;
        double d7 = d2 - d4;
        double d8 = Math.PI * d7 / 180.0;
        double d9 = Math.sin(d5) * Math.sin(d6) + Math.cos(d5) * Math.cos(d6) * Math.cos(d8);
        if (d9 > 1.0) {
            d9 = 1.0;
        }
        d9 = Math.acos(d9);
        d9 = d9 * 180.0 / Math.PI;
        d9 = d9 * 60.0 * 1.1515;
        if (distanceUnit == DistanceUnit.KILOMETER) {
            d9 *= 1.609344;
        }
        return d9;
    }

    public static String format(IAddress iAddress) {
        if (iAddress != null) {
            String string = iAddress.getAddressLine1();
            if (StringHelper.isNotBlank((Object)string)) {
                String string2 = iAddress.getAddressLine2();
                return StringHelper.isBlank((Object)string2) ? string : string + "\n" + string2;
            }
            if (StringHelper.isNotBlank((Object)iAddress.getStreet())) {
                StringBuilder stringBuilder = new StringBuilder(iAddress.getStreet());
                if (StringHelper.isNotBlank((Object)iAddress.getBuildingNumber())) {
                    stringBuilder.append(", ").append(iAddress.getBuildingNumber());
                }
                if (StringHelper.isNotBlank((Object)iAddress.getComplement())) {
                    stringBuilder.append(", ").append(iAddress.getComplement());
                }
                return stringBuilder.toString();
            }
            if (StringHelper.isNotBlank((Object)iAddress.getCity())) {
                return iAddress.getCity();
            }
        }
        return "";
    }

    public static String getDefaultValue(AddressFields addressFields, AddressConfigurationData addressConfigurationData) {
        switch (addressFields) {
            case CITY: {
                return addressConfigurationData.getDefaultCity();
            }
            case COUNTRY: {
                return addressConfigurationData.getDefaultCountry();
            }
            case REGION: {
                return addressConfigurationData.getDefaultRegion();
            }
        }
        return null;
    }

    public static Property<String, AddressDTO> getDTOPropertyForField(AddressFields addressFields) {
        switch (addressFields) {
            case ADDRESS_LINE_1: {
                return AddressDTO.ADDRESS_LINE_1;
            }
            case ADDRESS_LINE_2: {
                return AddressDTO.ADDRESS_LINE_2;
            }
            case CITY: {
                return AddressDTO.CITY;
            }
            case COUNTRY: {
                return AddressDTO.COUNTRY;
            }
            case NEIGHBORHOOD: {
                return AddressDTO.NEIGHBORHOOD;
            }
            case PO_BOX: {
                return AddressDTO.PO_BOX;
            }
            case REGION: {
                return AddressDTO.REGION;
            }
            case ZIP: {
                return AddressDTO.ZIP;
            }
            case STREET: {
                return AddressDTO.STREET;
            }
            case BUILDING_NUMBER: {
                return AddressDTO.BUILDING_NUMBER;
            }
            case COMPLEMENT: {
                return AddressDTO.COMPLEMENT;
            }
        }
        throw new IllegalArgumentException("Unknown address field: " + String.valueOf(addressFields));
    }

    public static String getValue(AddressFields addressFields, IAddress iAddress) {
        if (iAddress == null) {
            return null;
        }
        switch (addressFields) {
            case ADDRESS_LINE_1: {
                return iAddress.getAddressLine1();
            }
            case ADDRESS_LINE_2: {
                return iAddress.getAddressLine2();
            }
            case CITY: {
                return iAddress.getCity();
            }
            case COUNTRY: {
                return iAddress.getCountry();
            }
            case NEIGHBORHOOD: {
                return iAddress.getNeighborhood();
            }
            case PO_BOX: {
                return iAddress.getPoBox();
            }
            case REGION: {
                return iAddress.getRegion();
            }
            case ZIP: {
                return iAddress.getZip();
            }
            case BUILDING_NUMBER: {
                return iAddress.getBuildingNumber();
            }
            case COMPLEMENT: {
                return iAddress.getComplement();
            }
            case STREET: {
                return iAddress.getStreet();
            }
        }
        throw new IllegalArgumentException("Unknown address field: " + String.valueOf(addressFields));
    }

    public static Property<String, AddressVO> getVOPropertyForField(AddressFields addressFields) {
        switch (addressFields) {
            case ADDRESS_LINE_1: {
                return AddressVO.ADDRESS_LINE_1;
            }
            case ADDRESS_LINE_2: {
                return AddressVO.ADDRESS_LINE_2;
            }
            case CITY: {
                return AddressVO.CITY;
            }
            case COUNTRY: {
                return AddressVO.COUNTRY;
            }
            case NEIGHBORHOOD: {
                return AddressVO.NEIGHBORHOOD;
            }
            case PO_BOX: {
                return AddressVO.PO_BOX;
            }
            case REGION: {
                return AddressVO.REGION;
            }
            case ZIP: {
                return AddressVO.ZIP;
            }
            case BUILDING_NUMBER: {
                return AddressVO.BUILDING_NUMBER;
            }
            case COMPLEMENT: {
                return AddressVO.COMPLEMENT;
            }
            case STREET: {
                return AddressVO.STREET;
            }
        }
        throw new IllegalArgumentException("Unknown address field: " + String.valueOf(addressFields));
    }

    public static boolean isEquals(IAddress iAddress, IAddress iAddress2) {
        if (!(Objects.equals(iAddress.getAddressLine1(), iAddress2.getAddressLine1()) && Objects.equals(iAddress.getAddressLine2(), iAddress2.getAddressLine2()) && Objects.equals(iAddress.getCity(), iAddress2.getCity()) && Objects.equals(iAddress.getCountry(), iAddress2.getCountry()))) {
            return false;
        }
        if (!Objects.equals(iAddress.getNeighborhood(), iAddress2.getNeighborhood())) {
            return false;
        }
        if (!Objects.equals(iAddress.getPoBox(), iAddress2.getPoBox())) {
            return false;
        }
        if (!Objects.equals(iAddress.getRegion(), iAddress2.getRegion())) {
            return false;
        }
        if (!Objects.equals(iAddress.getZip(), iAddress2.getZip())) {
            return false;
        }
        if (!Objects.equals(iAddress.getBuildingNumber(), iAddress2.getBuildingNumber())) {
            return false;
        }
        if (!Objects.equals(iAddress.getStreet(), iAddress2.getStreet())) {
            return false;
        }
        return Objects.equals(iAddress.getComplement(), iAddress2.getComplement());
    }

    public static boolean isLocalizable(IAddress iAddress) {
        return iAddress != null && StringHelper.areNotAllBlanks((Object[])new Object[]{iAddress.getAddressLine1(), iAddress.getStreet()}) && StringHelper.areNotAllBlanks((Object[])new Object[]{iAddress.getZip(), iAddress.getCity()});
    }

    public static boolean isRequired(List<AddressFields> list, AddressFields addressFields) {
        if (CollectionHelper.isNotEmpty(list)) {
            for (AddressFields addressFields2 : list) {
                if (addressFields != addressFields2) continue;
                return true;
            }
        }
        return false;
    }

    public static MessageKey resolveKey(Collection<AddressFields> collection, AddressFields addressFields) {
        if (addressFields == AddressFields.ADDRESS_LINE_1 && !collection.contains(AddressFields.ADDRESS_LINE_2)) {
            return UsersKeys.Addresses.ADDRESS_SINGLE_LINE;
        }
        return addressFields.getMessageKey();
    }

    public static void setValue(AddressFields addressFields, IAddress iAddress, String string) {
        switch (addressFields) {
            case ADDRESS_LINE_1: {
                iAddress.setAddressLine1(string);
                break;
            }
            case ADDRESS_LINE_2: {
                iAddress.setAddressLine2(string);
                break;
            }
            case CITY: {
                iAddress.setCity(string);
                break;
            }
            case COUNTRY: {
                iAddress.setCountry(string);
                break;
            }
            case NEIGHBORHOOD: {
                iAddress.setNeighborhood(string);
                break;
            }
            case PO_BOX: {
                iAddress.setPoBox(string);
                break;
            }
            case REGION: {
                iAddress.setRegion(string);
                break;
            }
            case ZIP: {
                iAddress.setZip(string);
                break;
            }
            case BUILDING_NUMBER: {
                iAddress.setBuildingNumber(string);
                break;
            }
            case COMPLEMENT: {
                iAddress.setComplement(string);
                break;
            }
            case STREET: {
                iAddress.setStreet(string);
            }
        }
    }

    public static AddressSnapshot snapshot(Collection<AddressFields> collection, AddressDTO addressDTO) {
        return new AddressSnapshot().snapshot(collection, addressDTO);
    }

    public static class AddressSnapshot {
        private Map<AddressFields, String> optionalFieldsMap;

        public boolean equals(Object object) {
            if (!(object instanceof AddressSnapshot)) {
                return false;
            }
            AddressSnapshot addressSnapshot = (AddressSnapshot)object;
            for (AddressFields addressFields : this.optionalFieldsMap.keySet()) {
                if (Objects.equals(this.optionalFieldsMap.get(addressFields), addressSnapshot.optionalFieldsMap.get(addressFields))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.optionalFieldsMap == null ? 0 : this.optionalFieldsMap.hashCode());
            return n;
        }

        public AddressSnapshot snapshot(Collection<AddressFields> collection, AddressDTO addressDTO) {
            if (CollectionHelper.isEmpty(collection)) {
                this.optionalFieldsMap = Collections.emptyMap();
            } else {
                this.optionalFieldsMap = new HashMap<AddressFields, String>();
                for (AddressFields addressFields : collection) {
                    Property<String, AddressDTO> property = AddressHelper.getDTOPropertyForField(addressFields);
                    this.optionalFieldsMap.put(addressFields, (String)addressDTO.get(property));
                }
            }
            return this;
        }
    }
}

