/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.services.users;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.QueryParseException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.system.configurations.ActiveConfigurationData;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.groups.InitialGroupVO;
import org.cyclos.model.users.users.PublicRegistrationDTO;
import org.cyclos.model.users.users.PublicRegistrationData;
import org.cyclos.model.users.users.UserDTO;
import org.cyclos.model.users.users.UserData;
import org.cyclos.model.users.users.UserDataParams;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.model.users.users.UserRegistrationByMemberDTO;
import org.cyclos.model.users.users.UserRegistrationDTO;
import org.cyclos.model.users.users.UserRegistrationResult;
import org.cyclos.model.users.users.UserSearchContext;
import org.cyclos.model.users.users.UserSearchData;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.users.users.UserWithFieldsVO;
import org.cyclos.model.users.users.UserWithRolesVO;
import org.cyclos.model.users.users.ValidateRegistrationFieldParams;
import org.cyclos.model.users.users.ViewProfileData;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.Transaction;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.services.CRUDWithConfirmationPasswordService;
import org.cyclos.utils.GwtIncompatible;
import org.cyclos.utils.Page;

public interface UserService
extends CRUDWithConfirmationPasswordService<UserDTO, UserData, UserDataParams> {
    public static final String SELF = "self";
    public static final String ANY_PRINCIPAL_TYPE = "*";
    public static final String PIN_PRINCIPAL_TYPE = "#";

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_ONLY)
    public FileInfo exportUsers(@NotNull ExportFormatVO var1, @NotNull UserQuery var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public ActiveConfigurationData getActiveConfiguration(@NotNull UserLocatorVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public UserWithRolesVO getCurrentUser() throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public PublicRegistrationData getPublicRegistrationData(@NotNull InitialGroupVO var1, String var2, String var3) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public List<InitialGroupVO> getPublicRegistrationGroups() throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public UserSearchData getSearchData(UserSearchContext var1, UserLocatorVO var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public List<InitialGroupVO> getUserRegistrationGroups(boolean var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public ViewProfileData getViewProfileData(@NotNull UserLocatorVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public UserVO locate(@NotNull UserLocatorVO var1) throws FrameworkException, ValidationException, EntityNotFoundException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public UserRegistrationResult publicRegister(@NotNull PublicRegistrationDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public UserRegistrationResult register(@NotNull UserRegistrationDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public UserRegistrationResult registerByMember(@NotNull UserRegistrationByMemberDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<UserWithFieldsVO> search(@NotNull UserQuery var1) throws FrameworkException, QueryParseException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public String validateRegistrationField(@NotNull ValidateRegistrationFieldParams var1) throws FrameworkException;
}

