/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.services.users;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.QueryParseException;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.records.RecordDTO;
import org.cyclos.model.users.records.RecordData;
import org.cyclos.model.users.records.RecordDataParams;
import org.cyclos.model.users.records.RecordQuery;
import org.cyclos.model.users.records.RecordSearchData;
import org.cyclos.model.users.records.RecordVO;
import org.cyclos.model.users.records.SharedRecordFieldsSearchData;
import org.cyclos.model.users.records.TiledRecordsData;
import org.cyclos.model.users.recordtypes.RecordTypeCountVO;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.Transaction;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.services.CRUDWithConfirmationPasswordService;
import org.cyclos.utils.GwtIncompatible;
import org.cyclos.utils.Page;

public interface RecordService
extends CRUDWithConfirmationPasswordService<RecordDTO, RecordData, RecordDataParams> {
    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_ONLY)
    public FileInfo exportRecords(@NotNull ExportFormatVO var1, @NotNull RecordQuery var2);

    @Transaction(value=TransactionLevel.READ_ONLY)
    public List<RecordTypeCountVO> getRecordTypeCount(@NotNull InternalAccountOwner var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public RecordSearchData getSearchData(@NotNull RecordTypeVO var1, UserLocatorVO var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public SharedRecordFieldsSearchData getSharedFieldsSearchData() throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public TiledRecordsData getTiledRecordsData(@NotNull RecordTypeVO var1, UserLocatorVO var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public RecordVO loadVO(@NotNull Long var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<RecordVO> search(@NotNull RecordQuery var1) throws FrameworkException, QueryParseException;
}

