/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.services.marketplace;

import java.math.BigDecimal;
import javax.validation.constraints.NotNull;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.banking.InsufficientBalanceException;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.marketplace.CannotBuyException;
import org.cyclos.model.marketplace.OutOfStockException;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.marketplace.webshoporders.AcceptOrderParams;
import org.cyclos.model.marketplace.webshoporders.OrderDTO;
import org.cyclos.model.marketplace.webshoporders.OrderData;
import org.cyclos.model.marketplace.webshoporders.OrderDataParams;
import org.cyclos.model.marketplace.webshoporders.OrderQuery;
import org.cyclos.model.marketplace.webshoporders.OrderSearchData;
import org.cyclos.model.marketplace.webshoporders.OrderStatus;
import org.cyclos.model.marketplace.webshoporders.OrderVO;
import org.cyclos.model.marketplace.webshoporders.RejectOrderParams;
import org.cyclos.model.marketplace.webshoporders.SetDeliveryMethodParams;
import org.cyclos.model.marketplace.webshoporders.ShoppingCartCheckoutParams;
import org.cyclos.model.marketplace.webshoporders.ShoppingCartCheckoutResult;
import org.cyclos.model.marketplace.webshoporders.ShoppingCartDTO;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.Transaction;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.services.CRUDService;
import org.cyclos.utils.Page;

public interface OrderService
extends CRUDService<OrderDTO, OrderData, OrderDataParams> {
    @Transaction(value=TransactionLevel.READ_WRITE)
    public OrderStatus accept(@NotNull AcceptOrderParams var1) throws FrameworkException, TransferException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public int addToCart(@NotNull BasicAdVO var1, BigDecimal var2) throws FrameworkException, OutOfStockException, CannotBuyException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public ShoppingCartDTO adjustAndGetMyCart() throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public OrderData adjustShoppingCartAndGetData(@NotNull OrderVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public void checkCartStock(@NotNull UserLocatorVO var1, @NotNull CurrencyVO var2) throws FrameworkException, OutOfStockException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public ShoppingCartCheckoutResult checkout(@NotNull ShoppingCartCheckoutParams var1) throws FrameworkException, OutOfStockException, InsufficientBalanceException, CannotBuyException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public int countCartItems() throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY_TRANSACTION)
    public FileInfo exportOrder(ExportFormatVO var1, OrderVO var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public OrderData getCheckoutData(@NotNull UserLocatorVO var1, @NotNull CurrencyVO var2) throws FrameworkException, EntityNotFoundException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public ShoppingCartDTO getMyCart() throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public OrderData getOrderData(@NotNull OrderVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public long getOrderId(OrderVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public OrderSearchData getSearchData(@NotNull UserLocatorVO var1, boolean var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public int modifyQuantityOnCart(@NotNull BasicAdVO var1, BigDecimal var2) throws FrameworkException, IllegalActionException, OutOfStockException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void reject(@NotNull RejectOrderParams var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public int removeCart(@NotNull UserLocatorVO var1, CurrencyVO var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public int removeCartById(@NotNull Long var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public int removeCartItem(@NotNull BasicAdVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<OrderVO> search(@NotNull OrderQuery var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void setDeliveryMethod(@NotNull SetDeliveryMethodParams var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public Long submitToBuyer(@NotNull OrderDTO var1) throws FrameworkException, OutOfStockException;
}

