/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.services.contentmanagement;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.contentmanagement.documents.DocumentDTO;
import org.cyclos.model.contentmanagement.documents.DocumentData;
import org.cyclos.model.contentmanagement.documents.DocumentDataParams;
import org.cyclos.model.contentmanagement.documents.DocumentQuery;
import org.cyclos.model.contentmanagement.documents.DocumentSearchData;
import org.cyclos.model.contentmanagement.documents.DocumentVO;
import org.cyclos.model.contentmanagement.documents.ProcessDynamicDocumentDTO;
import org.cyclos.model.contentmanagement.documents.ProcessDynamicDocumentData;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.RawFileVO;
import org.cyclos.model.utils.Transaction;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.CRUDService;
import org.cyclos.utils.GwtIncompatible;
import org.cyclos.utils.Page;

public interface DocumentService
extends CRUDService<DocumentDTO, DocumentData, DocumentDataParams> {
    @Transaction(value=TransactionLevel.READ_ONLY)
    public DocumentVO getDocument(@NotNull DocumentVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public RawFileVO getDocumentFile(@NotNull DocumentVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public DocumentSearchData getDocumentSearchData(UserLocatorVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public ProcessDynamicDocumentData getProcessDynamicDocumentData(@NotNull DocumentVO var1, UserLocatorVO var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public List<DocumentVO> listUserDocuments(UserLocatorVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public String processDynamicDocument(@NotNull ProcessDynamicDocumentDTO var1) throws FrameworkException;

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_ONLY_TRANSACTION)
    public SerializableInputStream readContent(@NotNull DocumentVO var1) throws FrameworkException;

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_WRITE)
    public void saveFile(@NotNull DocumentVO var1, String var2, String var3, SerializableInputStream var4) throws FrameworkException;

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_WRITE)
    public Long saveWithFile(@NotNull DocumentDTO var1, String var2, String var3, SerializableInputStream var4) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<DocumentVO> search(@NotNull DocumentQuery var1) throws FrameworkException;
}

