/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.services.banking;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.CaptchaResponseDTO;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.vouchers.ActivateGiftVoucherDTO;
import org.cyclos.model.banking.vouchers.AssignVoucherDTO;
import org.cyclos.model.banking.vouchers.BasicVoucherQuery;
import org.cyclos.model.banking.vouchers.BuyVoucherData;
import org.cyclos.model.banking.vouchers.BuyVoucherPreviewVO;
import org.cyclos.model.banking.vouchers.BuyVouchersDTO;
import org.cyclos.model.banking.vouchers.CancelVoucherDTO;
import org.cyclos.model.banking.vouchers.ChangeVoucherExpirationDateDTO;
import org.cyclos.model.banking.vouchers.ChangeVoucherNotificationSettingsDTO;
import org.cyclos.model.banking.vouchers.ChangeVoucherPinDTO;
import org.cyclos.model.banking.vouchers.CreateVoucherDataParams;
import org.cyclos.model.banking.vouchers.GeneralVoucherQuery;
import org.cyclos.model.banking.vouchers.GeneralVouchersSearchData;
import org.cyclos.model.banking.vouchers.GenerateVouchersDTO;
import org.cyclos.model.banking.vouchers.GenerateVouchersData;
import org.cyclos.model.banking.vouchers.InitialVoucherUserData;
import org.cyclos.model.banking.vouchers.MaxTotalOpenAmountException;
import org.cyclos.model.banking.vouchers.RedeemVoucherDTO;
import org.cyclos.model.banking.vouchers.RedeemVoucherData;
import org.cyclos.model.banking.vouchers.RedeemVoucherPreviewVO;
import org.cyclos.model.banking.vouchers.SendVoucherDTO;
import org.cyclos.model.banking.vouchers.SimpleChangeVoucherNotificationSettingsDTO;
import org.cyclos.model.banking.vouchers.SimpleChangeVoucherPinDTO;
import org.cyclos.model.banking.vouchers.TopUpVoucherDTO;
import org.cyclos.model.banking.vouchers.TopUpVoucherData;
import org.cyclos.model.banking.vouchers.TopUpVoucherPreviewVO;
import org.cyclos.model.banking.vouchers.UnblockVoucherParams;
import org.cyclos.model.banking.vouchers.UserVoucherQuery;
import org.cyclos.model.banking.vouchers.UserVouchersSearchData;
import org.cyclos.model.banking.vouchers.VoucherBarcodeParams;
import org.cyclos.model.banking.vouchers.VoucherBuyingException;
import org.cyclos.model.banking.vouchers.VoucherData;
import org.cyclos.model.banking.vouchers.VoucherInfoData;
import org.cyclos.model.banking.vouchers.VoucherInfoTransactionsQuery;
import org.cyclos.model.banking.vouchers.VoucherInfoVO;
import org.cyclos.model.banking.vouchers.VoucherPackWithIdsVO;
import org.cyclos.model.banking.vouchers.VoucherRedeemingException;
import org.cyclos.model.banking.vouchers.VoucherTopUpException;
import org.cyclos.model.banking.vouchers.VoucherTransactionData;
import org.cyclos.model.banking.vouchers.VoucherTransactionDataParams;
import org.cyclos.model.banking.vouchers.VoucherTransactionResultVO;
import org.cyclos.model.banking.vouchers.VoucherTransactionVO;
import org.cyclos.model.banking.vouchers.VoucherTransactionsQuery;
import org.cyclos.model.banking.vouchers.VoucherTransactionsSearchData;
import org.cyclos.model.banking.vouchers.VoucherVO;
import org.cyclos.model.banking.vouchers.VouchersSummaryVO;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.Transaction;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.MaskValueInLog;
import org.cyclos.services.Service;
import org.cyclos.utils.GwtIncompatible;
import org.cyclos.utils.Page;

public interface VoucherService
extends Service {
    @Transaction(value=TransactionLevel.READ_WRITE)
    public VoucherInfoVO activateGiftVoucher(@NotNull String var1, ActivateGiftVoucherDTO var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void assign(@NotNull AssignVoucherDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    @GwtIncompatible
    public SerializableInputStream barcode(@NotNull VoucherBarcodeParams var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public VoucherPackWithIdsVO buy(@NotNull BuyVouchersDTO var1) throws FrameworkException, VoucherBuyingException, MaxTotalOpenAmountException, TransferException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void cancel(@NotNull CancelVoucherDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void changeExpirationDate(@NotNull ChangeVoucherExpirationDateDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void changeInfoNotificationSettings(@NotNull String var1, @NotNull @MaskValueInLog String var2, SimpleChangeVoucherNotificationSettingsDTO var3) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void changeInfoPin(@NotNull String var1, SimpleChangeVoucherPinDTO var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void changeNotificationSettings(ChangeVoucherNotificationSettingsDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void changePin(ChangeVoucherPinDTO var1) throws FrameworkException;

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_ONLY)
    public FileInfo exportTransaction(@NotNull ExportFormatVO var1, @NotNull VoucherTransactionVO var2) throws FrameworkException;

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_WRITE)
    public FileInfo exportVoucher(@NotNull ExportFormatVO var1, @NotNull VoucherVO var2, boolean var3) throws FrameworkException;

    @GwtIncompatible
    @Transaction(value=TransactionLevel.READ_WRITE)
    public FileInfo exportVouchers(@NotNull ExportFormatVO var1, @NotNull BasicVoucherQuery var2, boolean var3) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public List<VouchersSummaryVO> generalSearchSummary(@NotNull GeneralVoucherQuery var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public VoucherPackWithIdsVO generate(@NotNull GenerateVouchersDTO var1) throws FrameworkException, MaxTotalOpenAmountException, TransferException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public BuyVoucherData getBuyData(@NotNull CreateVoucherDataParams var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public VoucherData getData(@NotNull Long var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public GeneralVouchersSearchData getGeneralSearchData() throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public GenerateVouchersData getGenerateData(@NotNull CreateVoucherDataParams var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public VoucherInfoVO getInfo(@NotNull String var1, @MaskValueInLog String var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public VoucherInfoData getInfoData() throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public RedeemVoucherData getRedeemData(@NotNull VoucherTransactionDataParams var1) throws FrameworkException, VoucherRedeemingException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public InitialVoucherUserData getRedeemInitialData(UserLocatorVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public BuyVoucherData getSendData(@NotNull CreateVoucherDataParams var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public TopUpVoucherData getTopUpData(@NotNull VoucherTransactionDataParams var1) throws FrameworkException, VoucherTopUpException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public InitialVoucherUserData getTopUpInitialData(UserLocatorVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public VoucherTransactionData getTransactionData(Long var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public VoucherTransactionsSearchData getUserTransactionsSearchData(UserLocatorVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public UserVouchersSearchData getUserVouchersSearchData(UserLocatorVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public VoucherVO loadByToken(@NotNull String var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public BuyVoucherPreviewVO previewBuy(@NotNull BuyVouchersDTO var1) throws FrameworkException, VoucherBuyingException, MaxTotalOpenAmountException, TransferException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public RedeemVoucherPreviewVO previewRedeem(@NotNull RedeemVoucherDTO var1) throws FrameworkException, VoucherRedeemingException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public BuyVoucherPreviewVO previewSend(@NotNull SendVoucherDTO var1) throws FrameworkException, VoucherBuyingException, MaxTotalOpenAmountException, TransferException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public TopUpVoucherPreviewVO previewTopUp(@NotNull TopUpVoucherDTO var1) throws FrameworkException, VoucherTopUpException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public VoucherTransactionResultVO redeem(@NotNull RedeemVoucherDTO var1) throws FrameworkException, VoucherRedeemingException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void resendEmail(@NotNull VoucherVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public List<String> resendPin(@NotNull String var1, CaptchaResponseDTO var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public List<String> resendPinForRedeem(@NotNull String var1, UserLocatorVO var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<VoucherVO> searchGeneral(@NotNull GeneralVoucherQuery var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<VoucherTransactionVO> searchInfoTransactions(@NotNull VoucherInfoTransactionsQuery var1, @MaskValueInLog String var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<VoucherTransactionResultVO> searchTransactions(@NotNull VoucherTransactionsQuery var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public Page<VoucherVO> searchUser(@NotNull UserVoucherQuery var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public VoucherPackWithIdsVO send(@NotNull SendVoucherDTO var1) throws FrameworkException, VoucherBuyingException, MaxTotalOpenAmountException, TransferException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public VoucherTransactionResultVO topUp(@NotNull TopUpVoucherDTO var1) throws FrameworkException, VoucherTopUpException, TransferException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void unblock(@NotNull UnblockVoucherParams var1) throws FrameworkException, VoucherTopUpException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void unblockPin(@NotNull VoucherVO var1) throws FrameworkException;
}

