/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.services.banking;

import javax.validation.constraints.NotNull;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.transactions.ApproveTicketDTO;
import org.cyclos.model.banking.transactions.ApproveTicketPreviewVO;
import org.cyclos.model.banking.transactions.CreateTicketDTO;
import org.cyclos.model.banking.transactions.CreateTicketData;
import org.cyclos.model.banking.transactions.ProcessTicketDTO;
import org.cyclos.model.banking.transactions.TicketBarcodeParams;
import org.cyclos.model.banking.transactions.TicketData;
import org.cyclos.model.banking.transactions.TicketPaymentTypeData;
import org.cyclos.model.banking.transactions.TicketProcessResult;
import org.cyclos.model.banking.transactions.TicketVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.Transaction;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.Service;
import org.cyclos.utils.GwtIncompatible;
import org.cyclos.utils.RunInChannel;

public interface TicketService
extends Service {
    @Transaction(value=TransactionLevel.READ_WRITE)
    @RunInChannel(value=BuiltInChannel.TICKET)
    public TicketVO approve(@NotNull ApproveTicketDTO var1) throws TransferException, FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    @GwtIncompatible
    @RunInChannel(value=BuiltInChannel.TICKET)
    public SerializableInputStream barcode(@NotNull TicketBarcodeParams var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void cancel(@NotNull TicketVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public TicketVO create(@NotNull CreateTicketDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public CreateTicketData getCreateData(UserLocatorVO var1, UserLocatorVO var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public TicketData getData(@NotNull TicketVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public TicketPaymentTypeData getTicketPaymentTypeData(UserLocatorVO var1, @NotNull TransferTypeVO var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    @RunInChannel(value=BuiltInChannel.TICKET)
    public ApproveTicketPreviewVO previewApprove(@NotNull TicketVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    @RunInChannel(value=BuiltInChannel.TICKET)
    public TicketProcessResult process(ProcessTicketDTO var1) throws TransferException, FrameworkException;
}

