/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.utils.PrefixedEnum;

public class PrefixedEnumDeSer {
    private final BidiMap<String, Class<? extends PrefixedEnum>> mapping;

    public PrefixedEnumDeSer(Map<String, Class<? extends PrefixedEnum>> map) {
        this.mapping = new DualHashBidiMap(map);
    }

    public <E extends PrefixedEnum> JsonDeserializer<E> createDeserializer(final Class<E> clazz) {
        return new JsonDeserializer<E>(){

            public E deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
                Class clazz2;
                String string = jsonParser.getValueAsString();
                String string2 = StringUtils.substringAfterLast((String)string, (String)".");
                if (clazz.isEnum()) {
                    clazz2 = clazz;
                    if (string2.isEmpty()) {
                        string2 = string;
                    }
                } else {
                    String string3 = StringUtils.substringBefore((String)string, (String)".");
                    clazz2 = (Class)PrefixedEnumDeSer.this.mapping.get((Object)string3);
                    if (clazz2 == null) {
                        throw new IllegalArgumentException("Invalid enum prefix: " + string);
                    }
                }
                return (PrefixedEnum)Enum.valueOf(clazz2, string2);
            }

            public Class<?> handledType() {
                return clazz;
            }
        };
    }

    public <E extends PrefixedEnum> JsonSerializer<E> createSerializer(final Class<E> clazz) {
        return new JsonSerializer<E>(){

            public Class<E> handledType() {
                return clazz;
            }

            public void serialize(E e, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
                String string = (String)PrefixedEnumDeSer.this.mapping.getKey((Object)e.getClass());
                if (string == null) {
                    throw new IllegalArgumentException("No prefix mapping for " + String.valueOf(e));
                }
                jsonGenerator.writeString(string + "." + e.name());
            }
        };
    }

    public Set<Class<? extends PrefixedEnum>> getEnumClasses() {
        return this.mapping.values();
    }
}

