/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils.jackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.cyclos.model.system.imports.AdImportField;
import org.cyclos.model.system.imports.GeneralReferenceImportField;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.model.system.imports.RecordImportField;
import org.cyclos.model.system.imports.TokenImportField;
import org.cyclos.model.system.imports.TransactionImportField;
import org.cyclos.model.system.imports.UserImportField;

public class ImportFieldSerializer
extends StdSerializer<ImportField> {
    private static final long serialVersionUID = 1L;

    public ImportFieldSerializer() {
        super(ImportField.class);
    }

    public void serialize(ImportField importField, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (importField instanceof UserImportField) {
            jsonGenerator.writeString("USER." + String.valueOf(importField));
        } else if (importField instanceof AdImportField) {
            jsonGenerator.writeString("AD." + String.valueOf(importField));
        } else if (importField instanceof GeneralReferenceImportField) {
            jsonGenerator.writeString("REFERENCE." + String.valueOf(importField));
        } else if (importField instanceof RecordImportField) {
            jsonGenerator.writeString("RECORD." + String.valueOf(importField));
        } else if (importField instanceof TokenImportField) {
            jsonGenerator.writeString("TOKEN." + String.valueOf(importField));
        } else if (importField instanceof TransactionImportField) {
            jsonGenerator.writeString("TRANSACTION." + String.valueOf(importField));
        } else {
            jsonGenerator.writeNull();
        }
    }
}

