/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.cyclos.server.utils.BaseHttpServiceProxyProvider;
import org.cyclos.server.utils.HttpServiceFactory;
import org.cyclos.server.utils.WebRpcException;
import org.cyclos.server.utils.jackson.JacksonConfiguration;
import org.cyclos.services.Service;
import org.cyclos.utils.StringHelper;

public class WebRpcServiceProxyProvider
extends BaseHttpServiceProxyProvider {
    private static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 100;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 5;
    protected CloseableHttpClient httpClient;
    protected ObjectMapper objectMapper;

    @Override
    public Object createProxy(Class<? extends Service> clazz) {
        WebRpcInvocationHandler webRpcInvocationHandler = new WebRpcInvocationHandler(clazz);
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)webRpcInvocationHandler);
    }

    @Override
    public void destroy() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void doInitialize(HttpServiceFactory httpServiceFactory) {
        this.objectMapper = new JacksonConfiguration().getObjectMapper();
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(registry);
        poolingHttpClientConnectionManager.setMaxTotal(100);
        poolingHttpClientConnectionManager.setDefaultMaxPerRoute(5);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(httpServiceFactory.getReadTimeout()).setConnectTimeout(httpServiceFactory.getConnectTimeout()).setConnectionRequestTimeout(httpServiceFactory.getConnectTimeout()).build();
        this.httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).setDefaultRequestConfig(requestConfig).build();
    }

    private class WebRpcInvocationHandler
    implements InvocationHandler {
        private Class<?> serviceInterface;

        public WebRpcInvocationHandler(Class<?> clazz) {
            this.serviceInterface = clazz;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            CloseableHttpResponse closeableHttpResponse;
            JsonNode jsonNode = this.createBodyNode(method, objectArray);
            String string = WebRpcServiceProxyProvider.this.rootUrl + "/web-rpc/" + StringHelper.lowercaseFirst((String)this.serviceInterface.getSimpleName());
            HttpPost httpPost = new HttpPost(string);
            StringEntity stringEntity = new StringEntity(WebRpcServiceProxyProvider.this.objectMapper.writeValueAsString((Object)jsonNode), StandardCharsets.UTF_8);
            stringEntity.setContentType(ContentType.APPLICATION_JSON.getMimeType());
            stringEntity.setContentEncoding(StandardCharsets.UTF_8.name());
            httpPost.setEntity((HttpEntity)stringEntity);
            if (WebRpcServiceProxyProvider.this.invocationData != null && WebRpcServiceProxyProvider.this.invocationData.isValid()) {
                switch (WebRpcServiceProxyProvider.this.invocationData.getAccessType()) {
                    case LOGIN: {
                        closeableHttpResponse = new BasicHttpContext();
                        httpPost.addHeader(new BasicScheme().authenticate((Credentials)new UsernamePasswordCredentials(WebRpcServiceProxyProvider.this.invocationData.getPrincipal(), WebRpcServiceProxyProvider.this.invocationData.getPassword()), (HttpRequest)httpPost, (HttpContext)closeableHttpResponse));
                        if (WebRpcServiceProxyProvider.this.invocationData.getPrincipalType() == null) break;
                        httpPost.addHeader("Principal-Type", WebRpcServiceProxyProvider.this.invocationData.getPrincipalType());
                        break;
                    }
                    case SESSION: {
                        httpPost.addHeader("Session-Token", WebRpcServiceProxyProvider.this.invocationData.getSessionToken());
                        break;
                    }
                    case ACCESS_CLIENT: {
                        httpPost.addHeader("Access-Client-Token", WebRpcServiceProxyProvider.this.invocationData.getAccessClientToken());
                        break;
                    }
                    case OIDC: {
                        throw new UnsupportedOperationException("OpenID connect is not supported");
                    }
                }
            }
            int n = 0;
            HttpEntity httpEntity = null;
            try {
                closeableHttpResponse = WebRpcServiceProxyProvider.this.httpClient.execute((HttpUriRequest)httpPost);
                n = closeableHttpResponse.getStatusLine().getStatusCode();
                httpEntity = closeableHttpResponse.getEntity();
            }
            catch (HttpResponseException httpResponseException) {
                n = httpResponseException.getStatusCode();
            }
            JsonNode jsonNode2 = null;
            if (httpEntity != null) {
                try (InputStreamReader inputStreamReader = new InputStreamReader(httpEntity.getContent(), StandardCharsets.UTF_8);){
                    jsonNode2 = WebRpcServiceProxyProvider.this.objectMapper.readTree((Reader)inputStreamReader);
                }
                catch (Exception exception) {
                    WebRpcException webRpcException = new WebRpcException(n, "Parsing the response content in a request to " + string);
                    webRpcException.initCause(exception);
                    throw webRpcException;
                }
            }
            return this.processResult(method, n, jsonNode2);
        }

        private JsonNode createBodyNode(Method method, Object[] objectNode) {
            ArrayNode arrayNode = WebRpcServiceProxyProvider.this.objectMapper.createArrayNode();
            if (objectNode != null) {
                for (ObjectNode objectNode2 : objectNode) {
                    arrayNode.add(WebRpcServiceProxyProvider.this.objectMapper.valueToTree((Object)objectNode2));
                }
            }
            ObjectNode objectNode3 = WebRpcServiceProxyProvider.this.objectMapper.createObjectNode();
            objectNode3.set("operation", (JsonNode)new TextNode(method.getName()));
            objectNode3.set("params", (JsonNode)arrayNode);
            return objectNode3;
        }

        private Object processResult(Method method, int n, JsonNode jsonNode) throws Throwable {
            Object object;
            if (n == 200 && jsonNode != null) {
                JsonNode jsonNode2 = jsonNode.get("result");
                Type type = TypeToken.of(this.serviceInterface).resolveType(method.getGenericReturnType()).getType();
                JavaType javaType = WebRpcServiceProxyProvider.this.objectMapper.getTypeFactory().constructType(type);
                return jsonNode2 == null || javaType.getRawClass() == Void.TYPE ? null : WebRpcServiceProxyProvider.this.objectMapper.readValue(WebRpcServiceProxyProvider.this.objectMapper.treeAsTokens((TreeNode)jsonNode2), javaType);
            }
            if (jsonNode == null) {
                throw new WebRpcException(n, "No data returned from server");
            }
            JsonNode jsonNode3 = jsonNode.get("class");
            if (jsonNode3 != null) {
                object = StringHelper.trimToNull((Object)jsonNode3.asText());
                try {
                    Class<?> clazz = Class.forName((String)object);
                    Throwable throwable = (Throwable)WebRpcServiceProxyProvider.this.objectMapper.treeToValue((TreeNode)jsonNode, clazz);
                    for (Class<?> clazz2 : method.getExceptionTypes()) {
                        if (!clazz2.isInstance(throwable)) continue;
                        throw throwable;
                    }
                    WebRpcException webRpcException = new WebRpcException(n, "Unexpected exception thrown by " + String.valueOf(method));
                    webRpcException.initCause(throwable);
                    throw webRpcException;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            object = (Map)WebRpcServiceProxyProvider.this.objectMapper.treeToValue((TreeNode)jsonNode, HashMap.class);
            throw new WebRpcException(n, (Map<String, Object>)object);
        }
    }
}

