/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.utils;

import org.cyclos.model.general.GeneralKeys;
import org.cyclos.utils.EnumMessageKeyResolver;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum TimeField implements HasMessageKey
{
    MILLIS(1L),
    SECONDS(1000L),
    MINUTES(60L * TimeField.SECONDS.milliseconds),
    HOURS(60L * TimeField.MINUTES.milliseconds),
    DAYS(24L * TimeField.HOURS.milliseconds),
    WEEKS(7L * TimeField.DAYS.milliseconds),
    MONTHS(30L * TimeField.DAYS.milliseconds),
    YEARS(365L * TimeField.DAYS.milliseconds);

    private static EnumMessageKeyResolver<TimeField> resolverForSingular;
    private static EnumMessageKeyResolver<TimeField> resolverForPlural;
    private final long milliseconds;

    public static EnumMessageKeyResolver<TimeField> resolverForAmount(Integer n) {
        if (n != null && n == 1) {
            return TimeField.resolverForSingular();
        }
        return TimeField.resolverForPlural();
    }

    public static EnumMessageKeyResolver<TimeField> resolverForPlural() {
        if (resolverForPlural == null) {
            resolverForPlural = timeField -> {
                switch (timeField.ordinal()) {
                    case 4: {
                        return GeneralKeys.Ui.TIME_FIELD_PLURAL_DAYS;
                    }
                    case 3: {
                        return GeneralKeys.Ui.TIME_FIELD_PLURAL_HOURS;
                    }
                    case 0: {
                        return GeneralKeys.Ui.TIME_FIELD_PLURAL_MILLIS;
                    }
                    case 2: {
                        return GeneralKeys.Ui.TIME_FIELD_PLURAL_MINUTES;
                    }
                    case 6: {
                        return GeneralKeys.Ui.TIME_FIELD_PLURAL_MONTHS;
                    }
                    case 1: {
                        return GeneralKeys.Ui.TIME_FIELD_PLURAL_SECONDS;
                    }
                    case 5: {
                        return GeneralKeys.Ui.TIME_FIELD_PLURAL_WEEKS;
                    }
                    case 7: {
                        return GeneralKeys.Ui.TIME_FIELD_PLURAL_YEARS;
                    }
                }
                return null;
            };
        }
        return resolverForPlural;
    }

    public static EnumMessageKeyResolver<TimeField> resolverForSingular() {
        if (resolverForSingular == null) {
            resolverForSingular = timeField -> {
                switch (timeField.ordinal()) {
                    case 4: {
                        return GeneralKeys.Ui.TIME_FIELD_SINGULAR_DAYS;
                    }
                    case 3: {
                        return GeneralKeys.Ui.TIME_FIELD_SINGULAR_HOURS;
                    }
                    case 0: {
                        return GeneralKeys.Ui.TIME_FIELD_SINGULAR_MILLIS;
                    }
                    case 2: {
                        return GeneralKeys.Ui.TIME_FIELD_SINGULAR_MINUTES;
                    }
                    case 6: {
                        return GeneralKeys.Ui.TIME_FIELD_SINGULAR_MONTHS;
                    }
                    case 1: {
                        return GeneralKeys.Ui.TIME_FIELD_SINGULAR_SECONDS;
                    }
                    case 5: {
                        return GeneralKeys.Ui.TIME_FIELD_SINGULAR_WEEKS;
                    }
                    case 7: {
                        return GeneralKeys.Ui.TIME_FIELD_SINGULAR_YEARS;
                    }
                }
                return null;
            };
        }
        return resolverForSingular;
    }

    private TimeField(long l) {
        this.milliseconds = l;
    }

    @Override
    public MessageKey getMessageKey() {
        return TimeField.resolverForPlural().resolveKey(this);
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }
}

