/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.utils;

import java.io.Serializable;
import org.cyclos.model.utils.FileSizeUnit;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.GwtIncompatible;
import org.cyclos.utils.HasPartialData;
import org.cyclos.utils.StringHelper;

public class FileInfo
implements Serializable,
HasPartialData {
    private static final long serialVersionUID = 1L;
    @GwtIncompatible
    private SerializableInputStream content;
    private String contentType;
    private String encoding;
    private String name;
    private Integer length;
    private Long lastModified;
    private boolean partialData;

    @GwtIncompatible
    public SerializableInputStream getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public Integer getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPartialData() {
        return this.partialData;
    }

    @GwtIncompatible
    public void setContent(SerializableInputStream serializableInputStream) {
        this.content = serializableInputStream;
        if (serializableInputStream != null) {
            this.partialData = serializableInputStream.isPartialData();
        }
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setLastModified(Long l) {
        this.lastModified = l;
    }

    public void setLength(Integer n) {
        this.length = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPartialData(boolean bl) {
        this.partialData = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        if (StringHelper.isNotBlank((Object)this.contentType)) {
            stringBuilder.append(" (").append(this.contentType).append(")");
        }
        if (this.length != null) {
            stringBuilder.append(" ").append(FileSizeUnit.nearestFileSize(this.length.intValue()));
        }
        return stringBuilder.toString();
    }
}

