/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.utils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.model.ValidationException;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.GwtIncompatible;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

@GwtIncompatible
public class FieldSelector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final FieldSelector EMPTY = new FieldSelector(Collections.emptyList());
    private final FieldPath root;
    private Collection<String> fields;

    public static FieldSelector empty() {
        return EMPTY;
    }

    public static final FieldSelector of(Collection<String> collection) {
        return CollectionHelper.isEmpty(collection) ? FieldSelector.empty() : new FieldSelector(collection);
    }

    public static final FieldSelector of(String ... stringArray) {
        return FieldSelector.of(Arrays.asList(stringArray));
    }

    private FieldSelector(Collection<String> collection) {
        this.fields = collection;
        if (CollectionHelper.isEmpty(collection)) {
            this.root = null;
        } else {
            this.root = new FieldPath();
            for (String string : collection) {
                this.root.nested(string);
            }
        }
    }

    public void addExclude(String string, Collection<String> collection) {
        if (!this.includes(string)) {
            collection.add(string);
        }
    }

    public void apply(Object object) {
        if (object == null || this.root == null) {
            return;
        }
        this.doApplyFields(this.root, object, new IdentityHashMap<Object, Object>(30));
    }

    public Collection<String> getFields() {
        return Collections.unmodifiableCollection(this.fields);
    }

    public boolean includes(String string) {
        return this.root == null ? true : this.root.includes(string);
    }

    public void runIf(String string, Runnable runnable) {
        if (this.includes(string)) {
            runnable.run();
        }
    }

    public String toString() {
        return "FieldSelector [root=" + String.valueOf(this.root) + ", fields=" + String.valueOf(this.fields) + "]";
    }

    private void doApplyFields(FieldPath fieldPath, Object object, IdentityHashMap<Object, Object> identityHashMap) {
        if (fieldPath == null || !this.isFieldsProcessable(object) || identityHashMap.containsKey(object)) {
            return;
        }
        Object object2 = object instanceof Map ? IteratorUtils.singletonIterator((Object)object) : IteratorUtils.getIterator((Object)object);
        for (Object t : CollectionHelper.iterable((Iterator)object2)) {
            Consumer<String> consumer;
            Function<String, Object> function;
            Stream<String> stream;
            Object object3;
            boolean bl = identityHashMap.put(t, t) != null;
            if (bl) continue;
            if (this.isModel(t)) {
                object3 = new BeanWrapperImpl(t);
                stream = Stream.of(object3.getPropertyDescriptors()).map(propertyDescriptor -> propertyDescriptor.getWriteMethod() == null ? null : propertyDescriptor.getName()).filter(Objects::nonNull);
                function = arg_0 -> ((BeanWrapper)object3).getPropertyValue(arg_0);
                consumer = arg_0 -> FieldSelector.lambda$doApplyFields$1((BeanWrapper)object3, arg_0);
            } else {
                if (!(t instanceof Map)) continue;
                object3 = (Map)t;
                stream = new HashSet(object3.keySet()).stream().map(Objects::toString);
                function = ((Map)object3)::get;
                consumer = ((Map)object3)::remove;
            }
            stream.forEach(string -> {
                if (!fieldPath.includes((String)string)) {
                    consumer.accept((String)string);
                } else {
                    this.doApplyFields(fieldPath.get((String)string), function.apply((String)string), identityHashMap);
                }
            });
        }
    }

    private boolean isFieldsProcessable(Object object) {
        return this.isModel(object) || object instanceof Iterable || object instanceof Map;
    }

    private boolean isModel(Object object) {
        return object != null && object.getClass().getPackageName().startsWith("org.cyclos");
    }

    private static /* synthetic */ void lambda$doApplyFields$1(BeanWrapper beanWrapper, String string) {
        beanWrapper.setPropertyValue(string, null);
    }

    private static class FieldPath {
        private String name;
        private Map<String, FieldPath> blacklist = Collections.emptyMap();
        private Map<String, FieldPath> whitelist = Collections.emptyMap();
        private Map<String, FieldPath> greylist = Collections.emptyMap();

        public FieldPath() {
        }

        private FieldPath(String string) {
            this.name = string;
        }

        public FieldPath get(String string) {
            return (FieldPath)ObjectHelper.coalesce((Object[])new FieldPath[]{this.whitelist.get(string), this.greylist.get(string), this.blacklist.get(string)});
        }

        public boolean includes(String string) {
            String string2;
            int n = string.indexOf(46);
            String string3 = string2 = n < 0 ? string : string.substring(0, n);
            if (this.blacklist.containsKey(string2) || !this.whitelist.isEmpty() && !this.whitelist.containsKey(string2)) {
                return false;
            }
            if (n > 0) {
                String string4 = string.substring(n + 1);
                FieldPath fieldPath = this.blacklist.get(string2);
                if (fieldPath != null && fieldPath.includes(string4)) {
                    return false;
                }
                FieldPath fieldPath2 = this.greylist.get(string2);
                if (fieldPath2 != null && !fieldPath2.includes(string4)) {
                    return false;
                }
                FieldPath fieldPath3 = this.whitelist.get(string2);
                if (fieldPath3 != null && !fieldPath3.includes(string4)) {
                    return false;
                }
            }
            return true;
        }

        public void nested(String string) {
            Map<String, FieldPath> map;
            string = string.replace('!', '-');
            String string2 = StringUtils.removeStart((String)StringUtils.removeStart((String)StringUtils.removeStart((String)StringUtils.substringBefore((String)string, (String)"."), (String)"-"), (String)"*"), (String)"+");
            boolean bl = false;
            if (string.startsWith("-")) {
                if ((string = string.substring(1)).contains(".")) {
                    if (this.whitelist.containsKey(string2) || this.blacklist.containsKey(string2)) {
                        return;
                    }
                    if (this.greylist.isEmpty()) {
                        this.greylist = new LinkedHashMap<String, FieldPath>();
                    }
                    bl = true;
                    map = this.greylist;
                } else {
                    if (this.whitelist.containsKey(string2)) {
                        this.invalidField(string2);
                    }
                    if (this.blacklist.isEmpty()) {
                        this.blacklist = new LinkedHashMap<String, FieldPath>();
                    }
                    map = this.blacklist;
                    this.greylist.remove(string2);
                }
            } else if (string.startsWith("*")) {
                if (!string.contains(".")) {
                    throw new ValidationException("fields", String.format("Invalid field selection. Field %s cannot start with * and not contain a nested path.", string2));
                }
                if (this.whitelist.containsKey(string2) || this.blacklist.containsKey(string2)) {
                    return;
                }
                if (this.greylist.isEmpty()) {
                    this.greylist = new LinkedHashMap<String, FieldPath>();
                }
                map = this.greylist;
            } else {
                if (this.blacklist.containsKey(string2)) {
                    this.invalidField(string2);
                }
                if (this.whitelist.isEmpty()) {
                    this.whitelist = new LinkedHashMap<String, FieldPath>();
                }
                map = this.whitelist;
                this.greylist.remove(string2);
            }
            FieldPath fieldPath = map.computeIfAbsent(string2, FieldPath::new);
            if (string.contains(".")) {
                Object object = StringUtils.substringAfter((String)string, (String)".");
                if (bl && !((String)object).startsWith("-")) {
                    if (((String)object).startsWith("+")) {
                        throw new ValidationException("fields", String.format("Invalid field selection. Field %s cannot start with + and be nested within a field with -", string2));
                    }
                    object = "-" + (String)object;
                }
                fieldPath.nested((String)object);
            }
        }

        public String toString() {
            boolean bl;
            String string = (String)ObjectHelper.defaultValue((Object)this.name, (Object)"ROOT");
            boolean bl2 = !this.blacklist.isEmpty();
            boolean bl3 = !this.whitelist.isEmpty();
            boolean bl4 = bl = !this.greylist.isEmpty();
            if (!(bl2 || bl3 || bl)) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string).append("{");
            if (bl2) {
                stringBuilder.append(this.blacklist.values().stream().map(fieldPath -> "-" + String.valueOf(fieldPath)).collect(Collectors.joining(","))).append(',');
            }
            if (bl3) {
                stringBuilder.append(this.whitelist.values().stream().map(fieldPath -> "+" + String.valueOf(fieldPath)).collect(Collectors.joining(","))).append(',');
            }
            if (bl) {
                stringBuilder.append(this.greylist.values().stream().map(fieldPath -> "*" + String.valueOf(fieldPath)).collect(Collectors.joining(","))).append(',');
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            return stringBuilder.append("}").toString();
        }

        private void invalidField(String string) {
            throw new ValidationException("fields", String.format("Invalid field selection. Field %s cannot be both included and excluded.", string));
        }
    }
}

