/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.utils;

import org.cyclos.model.access.CredentialType;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.utils.CollectionHelper;

public class ActionConfirmationHelper {
    public static boolean isCanConfirm(CredentialInputDTO credentialInputDTO, CredentialType credentialType) {
        if (credentialInputDTO == null) {
            return true;
        }
        if (credentialType == null) {
            return CollectionHelper.isNotEmpty(credentialInputDTO.getActiveCredentials());
        }
        return CollectionHelper.orEmpty(credentialInputDTO.getAllowedCredentials()).contains(credentialType) && CollectionHelper.orEmpty(credentialInputDTO.getActiveCredentials()).contains(credentialType);
    }

    public static boolean isCanConfirmWithAny(CredentialInputDTO credentialInputDTO, CredentialType ... credentialTypeArray) {
        if (CollectionHelper.isNotEmpty((Object[])credentialTypeArray)) {
            for (CredentialType credentialType : credentialTypeArray) {
                if (!ActionConfirmationHelper.isCanConfirm(credentialInputDTO, credentialType)) continue;
                return true;
            }
        }
        return false;
    }
}

