/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.users.users;

import org.cyclos.model.users.UsersKeys;
import org.cyclos.utils.EnumMessageKeyResolver;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum UserStatus implements HasMessageKey
{
    PENDING,
    ACTIVE,
    BLOCKED,
    DISABLED,
    REMOVED,
    PURGED;

    private static EnumMessageKeyResolver<UserStatus> resolverForChangeStatus;

    public static EnumMessageKeyResolver<UserStatus> resolverForChangeStatus() {
        if (resolverForChangeStatus == null) {
            resolverForChangeStatus = userStatus -> {
                switch (userStatus.ordinal()) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return UsersKeys.Users.PROFILE_ACTIONS_USER_MANAGEMENT_CHANGE_STATUS_ACTIVE;
                    }
                    case 2: {
                        return UsersKeys.Users.PROFILE_ACTIONS_USER_MANAGEMENT_CHANGE_STATUS_BLOCKED;
                    }
                    case 3: {
                        return UsersKeys.Users.PROFILE_ACTIONS_USER_MANAGEMENT_CHANGE_STATUS_DISABLED;
                    }
                    case 4: {
                        return UsersKeys.Users.PROFILE_ACTIONS_USER_MANAGEMENT_CHANGE_STATUS_REMOVED;
                    }
                    case 5: {
                        return UsersKeys.Users.PROFILE_ACTIONS_USER_MANAGEMENT_CHANGE_STATUS_PURGED;
                    }
                }
                return null;
            };
        }
        return resolverForChangeStatus;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 1: {
                return UsersKeys.Users.STATUS_ACTIVE;
            }
            case 2: {
                return UsersKeys.Users.STATUS_BLOCKED;
            }
            case 3: {
                return UsersKeys.Users.STATUS_DISABLED;
            }
            case 0: {
                return UsersKeys.Users.STATUS_PENDING;
            }
            case 4: {
                return UsersKeys.Users.STATUS_REMOVED;
            }
            case 5: {
                return UsersKeys.Users.STATUS_PURGED;
            }
        }
        return null;
    }

    public boolean isRemoved() {
        return this == REMOVED || this == PURGED;
    }
}

