/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.users.dashboard;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cyclos.model.access.Role;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.configurations.Frontend;
import org.cyclos.model.utils.SvgIcon;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum QuickAccessType implements HasMessageKey
{
    ACCOUNT(SvgIcon.WALLET2, Role.MEMBER, Role.ADMIN),
    SCHEDULED_PAYMENTS(SvgIcon.CALENDAR_EVENT, Role.MEMBER, Role.ADMIN),
    TRANSFERS_OVERVIEW(SvgIcon.WALLET2_ARROW_LEFT_RIGHT, Role.ADMIN, Role.BROKER),
    TOKEN(SvgIcon.CREDIT_CARD, new Role[0]),
    PAY_USER(SvgIcon.WALLET2_ARROW_RIGHT, Role.MEMBER, Role.ADMIN),
    PAY_SYSTEM(SvgIcon.WALLET2_ARROW_RIGHT, Role.MEMBER, Role.ADMIN),
    PAY_SELF(SvgIcon.WALLET2_ARROW_LEFT_RIGHT, Role.MEMBER),
    POS(SvgIcon.CREDIT_CARD, Role.MEMBER),
    RECEIVE_QR_PAYMENT(SvgIcon.QR_CODE_SCAN, Role.MEMBER),
    TRANSACTION_FEEDBACKS(SvgIcon.STAR, Role.MEMBER),
    PAYMENT_REQUESTS(SvgIcon.WALLET2_ARROW_LEFT, Role.MEMBER, Role.ADMIN),
    REQUEST_PAYMENT_FROM_USER(SvgIcon.WALLET2_ARROW_LEFT, Role.MEMBER, Role.ADMIN),
    REQUEST_PAYMENT_FROM_SYSTEM(SvgIcon.WALLET2_ARROW_LEFT, Role.MEMBER),
    EXTERNAL_PAYMENTS(SvgIcon.ARROW_RIGHT_SQUARE, Role.MEMBER, Role.ADMIN),
    PAY_EXTERNAL_USER(SvgIcon.ARROW_RIGHT_SQUARE, Role.MEMBER, Role.ADMIN),
    OPERATION(SvgIcon.GEAR, new Role[0]),
    WIZARD(SvgIcon.GEAR, new Role[0]),
    VOUCHERS(SvgIcon.TICKET, Role.MEMBER, Role.ADMIN),
    BUY_VOUCHER(SvgIcon.TICKET_ARROW_LEFT, Role.MEMBER),
    SEND_VOUCHER(SvgIcon.TICKET_ARROW_RIGHT, Role.MEMBER),
    VOUCHER_TRANSACTIONS(SvgIcon.TICKET_DETAILED, Role.MEMBER),
    REDEEM_VOUCHER(SvgIcon.TICKET_ARROW_DOWN, Role.MEMBER),
    TOP_UP_VOUCHER(SvgIcon.TICKET_ARROW_UP, Role.MEMBER),
    SEARCH_USERS(SvgIcon.PEOPLE, Role.MEMBER, Role.ADMIN),
    BALANCES_OVERVIEW(SvgIcon.WALLET2_PERSON, Role.ADMIN, Role.BROKER),
    PENDING_USERS(SvgIcon.PERSON_CHECK, Role.ADMIN),
    CONTACTS(SvgIcon.PERSON_CHECK, new Role[0]),
    BROKERED_USERS(SvgIcon.PERSON_SQUARE_OUTLINE, Role.BROKER),
    REGISTER_USER(SvgIcon.PERSON_PLUS, Frontend.NEW, Role.ADMIN, Role.BROKER),
    INVITE_USER(SvgIcon.PERSON_PLUS, new Role[0]),
    SEARCH_ADS(SvgIcon.BAG, new Role[0]),
    AD_INTERESTS(SvgIcon.BAG, Role.MEMBER),
    PURCHASES(SvgIcon.CART3, Role.MEMBER),
    MY_ADS(SvgIcon.BASKET, Role.MEMBER),
    CREATE_AD(SvgIcon.BASKET, Role.MEMBER),
    MY_WEBSHOP(SvgIcon.BASKET, Role.MEMBER),
    CREATE_WEBSHOP_AD(SvgIcon.BASKET, Role.MEMBER),
    SALES(SvgIcon.RECEIPT, Role.MEMBER),
    EDIT_PROFILE(SvgIcon.PERSON, new Role[0]),
    PASSWORDS(SvgIcon.KEY, new Role[0]),
    REFERENCES(SvgIcon.STAR, Role.MEMBER),
    MESSAGES(SvgIcon.ENVELOPE, new Role[0]),
    SEND_MESSAGE(SvgIcon.ENVELOPE, new Role[0]),
    DOCUMENTS(SvgIcon.FILE_EARMARK_TEXT, new Role[0]),
    RECORD(SvgIcon.FILE_EARMARK_TEXT, new Role[0]),
    SETTINGS(SvgIcon.GEAR, Frontend.NEW, new Role[0]),
    NOTIFICATIONS(SvgIcon.BELL, new Role[0]),
    HELP(SvgIcon.QUESTION_CIRCLE, new Role[0]),
    SWITCH_FRONTEND(SvgIcon.DISPLAY, new Role[0]),
    SWITCH_THEME(SvgIcon.LIGHT_DARK, Frontend.NEW, new Role[0]);

    private final SvgIcon icon;
    private final Frontend specificFrontend;
    private final Set<Role> roles;

    public static Set<QuickAccessType> getByRole(Role role) {
        return Stream.of(QuickAccessType.values()).filter(quickAccessType -> quickAccessType.allows(role)).collect(Collectors.toCollection(() -> EnumSet.noneOf(QuickAccessType.class)));
    }

    private QuickAccessType(SvgIcon svgIcon, Frontend frontend, Role ... roleArray) {
        this.icon = svgIcon;
        this.specificFrontend = frontend;
        this.roles = Collections.unmodifiableSet(CollectionHelper.isEmpty((Object[])roleArray) ? CollectionHelper.asSet((Object[])new Role[]{Role.ADMIN, Role.MEMBER, Role.BROKER}) : CollectionHelper.asSet((Object[])roleArray));
    }

    private QuickAccessType(SvgIcon svgIcon, Role ... roleArray) {
        this(svgIcon, (Frontend)null, roleArray);
    }

    public boolean allows(Role role) {
        return this.roles.contains(role);
    }

    public SvgIcon getIcon() {
        return this.icon;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return GeneralKeys.Ui.QUICK_ACCESS_ACCOUNT;
            }
            case 31: {
                return GeneralKeys.Ui.QUICK_ACCESS_AD_INTERESTS;
            }
            case 24: {
                return GeneralKeys.Ui.QUICK_ACCESS_BALANCES_OVERVIEW;
            }
            case 27: {
                return GeneralKeys.Ui.QUICK_ACCESS_BROKERED_USERS;
            }
            case 18: {
                return GeneralKeys.Ui.QUICK_ACCESS_BUY_VOUCHER;
            }
            case 26: {
                return GeneralKeys.Ui.QUICK_ACCESS_CONTACTS;
            }
            case 34: {
                return GeneralKeys.Ui.QUICK_ACCESS_CREATE_AD;
            }
            case 36: {
                return GeneralKeys.Ui.QUICK_ACCESS_CREATE_WEBSHOP_AD;
            }
            case 43: {
                return GeneralKeys.Ui.QUICK_ACCESS_DOCUMENTS;
            }
            case 38: {
                return GeneralKeys.Ui.QUICK_ACCESS_EDIT_PROFILE;
            }
            case 13: {
                return GeneralKeys.Ui.QUICK_ACCESS_EXTERNAL_PAYMENTS;
            }
            case 47: {
                return GeneralKeys.Ui.QUICK_ACCESS_HELP;
            }
            case 29: {
                return GeneralKeys.Ui.QUICK_ACCESS_INVITE_USER;
            }
            case 41: {
                return GeneralKeys.Ui.QUICK_ACCESS_MESSAGES;
            }
            case 33: {
                return GeneralKeys.Ui.QUICK_ACCESS_MY_ADS;
            }
            case 35: {
                return GeneralKeys.Ui.QUICK_ACCESS_MY_WEBSHOP;
            }
            case 46: {
                return GeneralKeys.Ui.QUICK_ACCESS_NOTIFICATIONS;
            }
            case 15: {
                return GeneralKeys.Ui.QUICK_ACCESS_OPERATION;
            }
            case 39: {
                return GeneralKeys.Ui.QUICK_ACCESS_PASSWORDS;
            }
            case 10: {
                return GeneralKeys.Ui.QUICK_ACCESS_PAYMENT_REQUESTS;
            }
            case 14: {
                return GeneralKeys.Ui.QUICK_ACCESS_PAY_EXTERNAL_USER;
            }
            case 6: {
                return GeneralKeys.Ui.QUICK_ACCESS_PAY_SELF;
            }
            case 5: {
                return GeneralKeys.Ui.QUICK_ACCESS_PAY_SYSTEM;
            }
            case 4: {
                return GeneralKeys.Ui.QUICK_ACCESS_PAY_USER;
            }
            case 25: {
                return GeneralKeys.Ui.QUICK_ACCESS_PENDING_USERS;
            }
            case 7: {
                return GeneralKeys.Ui.QUICK_ACCESS_POS;
            }
            case 32: {
                return GeneralKeys.Ui.QUICK_ACCESS_PURCHASES;
            }
            case 8: {
                return GeneralKeys.Ui.QUICK_ACCESS_RECEIVE_QR_PAYMENT;
            }
            case 44: {
                return GeneralKeys.Ui.QUICK_ACCESS_RECORD;
            }
            case 21: {
                return GeneralKeys.Ui.QUICK_ACCESS_REDEEM_VOUCHER;
            }
            case 40: {
                return GeneralKeys.Ui.QUICK_ACCESS_REFERENCES;
            }
            case 28: {
                return GeneralKeys.Ui.QUICK_ACCESS_REGISTER_USER;
            }
            case 12: {
                return GeneralKeys.Ui.QUICK_ACCESS_REQUEST_PAYMENT_FROM_SYSTEM;
            }
            case 11: {
                return GeneralKeys.Ui.QUICK_ACCESS_REQUEST_PAYMENT_FROM_USER;
            }
            case 37: {
                return GeneralKeys.Ui.QUICK_ACCESS_SALES;
            }
            case 1: {
                return GeneralKeys.Ui.QUICK_ACCESS_SCHEDULED_PAYMENTS;
            }
            case 30: {
                return GeneralKeys.Ui.QUICK_ACCESS_SEARCH_ADS;
            }
            case 23: {
                return GeneralKeys.Ui.QUICK_ACCESS_SEARCH_USERS;
            }
            case 42: {
                return GeneralKeys.Ui.QUICK_ACCESS_SEND_MESSAGE;
            }
            case 19: {
                return GeneralKeys.Ui.QUICK_ACCESS_SEND_VOUCHER;
            }
            case 45: {
                return GeneralKeys.Ui.QUICK_ACCESS_SETTINGS;
            }
            case 48: {
                return GeneralKeys.Ui.QUICK_ACCESS_SWITCH_FRONTEND;
            }
            case 49: {
                return GeneralKeys.Ui.QUICK_ACCESS_SWITCH_THEME;
            }
            case 22: {
                return GeneralKeys.Ui.QUICK_ACCESS_TOP_UP_VOUCHER;
            }
            case 3: {
                return GeneralKeys.Ui.QUICK_ACCESS_TOKEN;
            }
            case 9: {
                return GeneralKeys.Ui.QUICK_ACCESS_TRANSACTION_FEEDBACKS;
            }
            case 2: {
                return GeneralKeys.Ui.QUICK_ACCESS_TRANSFERS_OVERVIEW;
            }
            case 17: {
                return GeneralKeys.Ui.QUICK_ACCESS_VOUCHERS;
            }
            case 20: {
                return GeneralKeys.Ui.QUICK_ACCESS_VOUCHER_TRANSACTIONS;
            }
            case 16: {
                return GeneralKeys.Ui.QUICK_ACCESS_WIZARD;
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasEntity() {
        return this == OPERATION || this == WIZARD || this == RECORD || this == TOKEN;
    }

    public boolean showIn(Frontend frontend) {
        return this.specificFrontend == null || this.specificFrontend == frontend;
    }
}

