/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.system.scripts;

import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.scripts.AuthenticationType;
import org.cyclos.model.system.scripts.CustomOperationScriptFunction;
import org.cyclos.model.system.scripts.CustomWizardScriptFunction;
import org.cyclos.model.system.scripts.DefaultScriptFunction;
import org.cyclos.model.system.scripts.ExtensionPointScriptFunction;
import org.cyclos.model.system.scripts.InboundSmsScriptFunction;
import org.cyclos.model.system.scripts.LoadValuesScriptFunction;
import org.cyclos.model.system.scripts.PhoneNumberHandlingScriptFunction;
import org.cyclos.model.system.scripts.ScriptFunction;
import org.cyclos.model.system.scripts.ServiceInterceptorScriptFunction;
import org.cyclos.model.system.scripts.SessionHandlingScriptFunction;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum ScriptType implements HasMessageKey
{
    LIBRARY(DefaultScriptFunction.class, AuthenticationType.NOT_SUPPORTED),
    CUSTOM_FIELD_VALIDATION(DefaultScriptFunction.class, AuthenticationType.CUSTOMIZABLE),
    LOAD_CUSTOM_FIELD_VALUES(LoadValuesScriptFunction.class, AuthenticationType.CUSTOMIZABLE),
    ACCOUNT_NUMBER_GENERATION(DefaultScriptFunction.class, AuthenticationType.SYSTEM),
    ACCOUNT_FEE_CALCULATION(DefaultScriptFunction.class, AuthenticationType.SYSTEM),
    TRANSFER_FEE_CALCULATION(DefaultScriptFunction.class, AuthenticationType.CUSTOMIZABLE),
    TRANSFER_STATUS(DefaultScriptFunction.class, AuthenticationType.CUSTOMIZABLE),
    SESSION_HANDLING(SessionHandlingScriptFunction.class, AuthenticationType.CUSTOMIZABLE),
    PASSWORD_HANDLING(DefaultScriptFunction.class, AuthenticationType.CUSTOMIZABLE),
    PHONE_NUMBER_HANDLING(PhoneNumberHandlingScriptFunction.class, AuthenticationType.CUSTOMIZABLE),
    EXTENSION_POINT(ExtensionPointScriptFunction.class, AuthenticationType.CUSTOMIZABLE),
    CUSTOM_OPERATION(CustomOperationScriptFunction.class, AuthenticationType.CUSTOMIZABLE),
    CUSTOM_WIZARD(CustomWizardScriptFunction.class, AuthenticationType.CUSTOMIZABLE),
    CUSTOM_WEB_SERVICE(DefaultScriptFunction.class, AuthenticationType.CUSTOMIZABLE),
    SERVICE_INTERCEPTOR(ServiceInterceptorScriptFunction.class, AuthenticationType.CUSTOMIZABLE),
    SCHEDULED_TASK(DefaultScriptFunction.class, AuthenticationType.SYSTEM),
    BACKGROUND_TASK(DefaultScriptFunction.class, AuthenticationType.SYSTEM),
    SMS_OPERATION(DefaultScriptFunction.class, AuthenticationType.CUSTOMIZABLE),
    INBOUND_SMS(InboundSmsScriptFunction.class, AuthenticationType.SYSTEM),
    OUTBOUND_SMS(DefaultScriptFunction.class, AuthenticationType.SYSTEM),
    LINK_GENERATION(DefaultScriptFunction.class, AuthenticationType.SYSTEM),
    EXPORT_FORMAT(DefaultScriptFunction.class, AuthenticationType.SYSTEM),
    NOTIFICATION(DefaultScriptFunction.class, AuthenticationType.SYSTEM),
    CONTENT_HELPER(DefaultScriptFunction.class, AuthenticationType.CUSTOMIZABLE),
    IP_GEOLOCATION(DefaultScriptFunction.class, AuthenticationType.SYSTEM);

    private Class<? extends ScriptFunction> functionClass;
    private AuthenticationType authenticationType;

    private ScriptType(Class<? extends ScriptFunction> clazz, AuthenticationType authenticationType) {
        this.functionClass = clazz;
        this.authenticationType = authenticationType;
    }

    public boolean allowAuthenticationCustomization() {
        return AuthenticationType.CUSTOMIZABLE == this.authenticationType;
    }

    public Class<? extends ScriptFunction> getFunctionClass() {
        return this.functionClass;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return SystemKeys.Scripts.TYPE_LIBRARY;
            }
            case 1: {
                return SystemKeys.Scripts.TYPE_CUSTOM_FIELD_VALIDATION;
            }
            case 2: {
                return SystemKeys.Scripts.TYPE_LOAD_CUSTOM_FIELD_VALUES;
            }
            case 3: {
                return SystemKeys.Scripts.TYPE_ACCOUNT_NUMBER_GENERATION;
            }
            case 4: {
                return SystemKeys.Scripts.TYPE_ACCOUNT_FEE_CALCULATION;
            }
            case 5: {
                return SystemKeys.Scripts.TYPE_TRANSFER_FEE_CALCULATION;
            }
            case 6: {
                return SystemKeys.Scripts.TYPE_TRANSFER_STATUS;
            }
            case 7: {
                return SystemKeys.Scripts.TYPE_SESSION_HANDLING;
            }
            case 8: {
                return SystemKeys.Scripts.TYPE_PASSWORD_HANDLING;
            }
            case 9: {
                return SystemKeys.Scripts.TYPE_PHONE_NUMBER_HANDLING;
            }
            case 21: {
                return SystemKeys.Scripts.TYPE_EXPORT_FORMAT;
            }
            case 10: {
                return SystemKeys.Scripts.TYPE_EXTENSION_POINT;
            }
            case 11: {
                return SystemKeys.Scripts.TYPE_CUSTOM_OPERATION;
            }
            case 12: {
                return SystemKeys.Scripts.TYPE_CUSTOM_WIZARD;
            }
            case 13: {
                return SystemKeys.Scripts.TYPE_CUSTOM_WEB_SERVICE;
            }
            case 15: {
                return SystemKeys.Scripts.TYPE_SCHEDULED_TASK;
            }
            case 16: {
                return SystemKeys.Scripts.TYPE_BACKGROUND_TASK;
            }
            case 17: {
                return SystemKeys.Scripts.TYPE_SMS_OPERATION;
            }
            case 18: {
                return SystemKeys.Scripts.TYPE_INBOUND_SMS;
            }
            case 19: {
                return SystemKeys.Scripts.TYPE_OUTBOUND_SMS;
            }
            case 20: {
                return SystemKeys.Scripts.TYPE_LINK_GENERATION;
            }
            case 14: {
                return SystemKeys.Scripts.TYPE_SERVICE_INTERCEPTOR;
            }
            case 22: {
                return SystemKeys.Scripts.TYPE_NOTIFICATION;
            }
            case 23: {
                return SystemKeys.Scripts.TYPE_CONTENT_HELPER;
            }
            case 24: {
                return SystemKeys.Scripts.TYPE_IP_GEOLOCATION;
            }
        }
        return null;
    }

    public boolean mustRunAsSystem() {
        return AuthenticationType.SYSTEM == this.authenticationType;
    }
}

