/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.system.networks;

import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.fields.CustomFieldControl;
import org.cyclos.model.system.fields.CustomFieldSize;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.ValueMatch;
import org.cyclos.model.system.networks.InitialCustomField;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum NetworkInitialProfileField implements InitialCustomField
{
    BIRTH_DATE(CustomFieldType.DATE, CustomFieldControl.TEXT, null, null, "birthdate", new Enum[0]),
    GENDER(CustomFieldType.SINGLE_SELECTION, CustomFieldControl.RADIO, null, null, "gender", GenderOptions.MALE, GenderOptions.FEMALE),
    MARITAL_STATUS(CustomFieldType.SINGLE_SELECTION, CustomFieldControl.SINGLE_SELECTION, CustomFieldSize.FULL, null, null, MaritalStatusOptions.SINGLE, MaritalStatusOptions.MARRIED, MaritalStatusOptions.DIVORCED, MaritalStatusOptions.WIDOWED),
    WEBSITE(CustomFieldType.URL, CustomFieldControl.TEXT, CustomFieldSize.LARGE, ValueMatch.EXACT, "website", new Enum[0]),
    ABOUT_ME(CustomFieldType.TEXT, CustomFieldControl.TEXTAREA, CustomFieldSize.LARGE, ValueMatch.TEXT, null, new Enum[0]);

    private final CustomFieldType type;
    private final CustomFieldControl control;
    private final CustomFieldSize size;
    private final ValueMatch valueMatch;
    private final String oidcClaim;
    private final Enum<?>[] enumeratedValues;

    private NetworkInitialProfileField(CustomFieldType customFieldType, CustomFieldControl customFieldControl, CustomFieldSize customFieldSize, ValueMatch valueMatch, String string2, Enum<?> ... enumArray) {
        this.type = customFieldType;
        this.control = customFieldControl;
        this.size = customFieldSize;
        this.valueMatch = valueMatch;
        this.oidcClaim = string2;
        this.enumeratedValues = enumArray;
    }

    @Override
    public CustomFieldControl getControl() {
        return this.control;
    }

    @Override
    public Enum<?>[] getEnumeratedValues() {
        return this.enumeratedValues;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return GeneralKeys.InitialData.PROFILE_FIELD_BIRTH_DATE;
            }
            case 1: {
                return GeneralKeys.InitialData.PROFILE_FIELD_GENDER;
            }
            case 2: {
                return GeneralKeys.InitialData.PROFILE_FIELD_MARITAL_STATUS;
            }
            case 3: {
                return GeneralKeys.InitialData.PROFILE_FIELD_WEBSITE;
            }
            case 4: {
                return GeneralKeys.InitialData.PROFILE_FIELD_ABOUT_ME;
            }
        }
        return null;
    }

    public String getOidcClaim() {
        return this.oidcClaim;
    }

    @Override
    public CustomFieldSize getSize() {
        return this.size;
    }

    @Override
    public CustomFieldType getType() {
        return this.type;
    }

    @Override
    public ValueMatch valueMatch() {
        return this.valueMatch;
    }

    private static enum GenderOptions implements HasMessageKey
    {
        MALE(GeneralKeys.InitialData.PROFILE_FIELD_GENDER_MALE),
        FEMALE(GeneralKeys.InitialData.PROFILE_FIELD_GENDER_FEMALE);

        private final MessageKey key;

        private GenderOptions(MessageKey messageKey) {
            this.key = messageKey;
        }

        @Override
        public MessageKey getMessageKey() {
            return this.key;
        }
    }

    private static enum MaritalStatusOptions implements HasMessageKey
    {
        SINGLE(GeneralKeys.InitialData.PROFILE_FIELD_MARITAL_STATUS_SINGLE),
        MARRIED(GeneralKeys.InitialData.PROFILE_FIELD_MARITAL_STATUS_MARRIED),
        DIVORCED(GeneralKeys.InitialData.PROFILE_FIELD_MARITAL_STATUS_DIVORCED),
        WIDOWED(GeneralKeys.InitialData.PROFILE_FIELD_MARITAL_STATUS_WIDOWED);

        private final MessageKey key;

        private MaritalStatusOptions(MessageKey messageKey) {
            this.key = messageKey;
        }

        @Override
        public MessageKey getMessageKey() {
            return this.key;
        }
    }
}

