/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.system.languages;

import org.cyclos.model.system.SystemKeys;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum NumberFormat implements HasMessageKey
{
    COMMA_AS_DECIMAL(',', '.'),
    PERIOD_AS_DECIMAL('.', ',');

    private final char groupingSeparator;
    private final char decimalSeparator;

    public static NumberFormat fromDecimalSeparator(char c) {
        switch (c) {
            case ',': {
                return COMMA_AS_DECIMAL;
            }
            case '.': {
                return PERIOD_AS_DECIMAL;
            }
        }
        throw new IllegalArgumentException("Invalid number format specification");
    }

    private NumberFormat(char c, char c2) {
        this.decimalSeparator = c;
        this.groupingSeparator = c2;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return SystemKeys.Languages.NUMBER_FORMAT_COMMA_AS_DECIMAL;
            }
            case 1: {
                return SystemKeys.Languages.NUMBER_FORMAT_PERIOD_AS_DECIMAL;
            }
        }
        return null;
    }
}

