/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.system.languages;

import java.util.Arrays;
import java.util.List;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.StringHelper;

public enum DateFormat implements HasMessageKey
{
    DMY_SLASH("dd/MM/yyyy", "/"),
    DMY_DASH("dd-MM-yyyy", "-"),
    DMY_PERIOD("dd.MM.yyyy", "."),
    MDY_SLASH("MM/dd/yyyy", "/"),
    MDY_DASH("MM-dd-yyyy", "-"),
    MDY_PERIOD("MM.dd.yyyy", "."),
    YMD_SLASH("yyyy/MM/dd", "/"),
    YMD_DASH("yyyy-MM-dd", "-"),
    YMD_PERIOD("yyyy.MM.dd", ".");

    private static final boolean OMIT_YEAR = false;
    private static final boolean INCLUDE_YEAR = true;
    private final String pattern;

    public static DateFormat forOrderAndSeparator(String string, char c) {
        if ("DMY".equals(string)) {
            switch (c) {
                case '/': {
                    return DMY_SLASH;
                }
                case '-': {
                    return DMY_DASH;
                }
                case '.': {
                    return DMY_PERIOD;
                }
            }
        } else if ("MDY".equals(string)) {
            switch (c) {
                case '/': {
                    return MDY_SLASH;
                }
                case '-': {
                    return MDY_DASH;
                }
                case '.': {
                    return MDY_PERIOD;
                }
            }
        } else if ("YMD".equals(string)) {
            switch (c) {
                case '/': {
                    return YMD_SLASH;
                }
                case '-': {
                    return YMD_DASH;
                }
                case '.': {
                    return YMD_PERIOD;
                }
            }
        }
        throw new IllegalArgumentException("Invalid date format specification");
    }

    private DateFormat(String string2, String string3) {
        this.pattern = string2;
    }

    public String format(DateTime dateTime) {
        return this.formatDate(dateTime, true);
    }

    public String formatRelative(DateTime dateTime, DateTime dateTime2) {
        if (dateTime.getYear() == dateTime2.getYear()) {
            return this.formatDate(dateTime2, false);
        }
        return this.formatDate(dateTime2, true);
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return SystemKeys.Languages.DATE_FORMAT_DMY_SLASH;
            }
            case 1: {
                return SystemKeys.Languages.DATE_FORMAT_DMY_DASH;
            }
            case 2: {
                return SystemKeys.Languages.DATE_FORMAT_DMY_PERIOD;
            }
            case 3: {
                return SystemKeys.Languages.DATE_FORMAT_MDY_SLASH;
            }
            case 4: {
                return SystemKeys.Languages.DATE_FORMAT_MDY_DASH;
            }
            case 5: {
                return SystemKeys.Languages.DATE_FORMAT_MDY_PERIOD;
            }
            case 6: {
                return SystemKeys.Languages.DATE_FORMAT_YMD_SLASH;
            }
            case 7: {
                return SystemKeys.Languages.DATE_FORMAT_YMD_DASH;
            }
            case 8: {
                return SystemKeys.Languages.DATE_FORMAT_YMD_PERIOD;
            }
        }
        return null;
    }

    public String getPattern() {
        return this.pattern;
    }

    private String formatDate(DateTime dateTime, boolean bl) {
        String string = String.valueOf(dateTime.getYear());
        String string2 = String.valueOf(dateTime.getMonth() + 1);
        String string3 = String.valueOf(dateTime.getDate());
        String string4 = this.getPattern();
        if (bl) {
            string4 = string4.replace("yyyy", StringHelper.leftPad((String)string, (int)4, (char)'0'));
        } else {
            List<String> list = Arrays.asList(DMY_DASH.getPattern(), DMY_PERIOD.getPattern(), DMY_SLASH.getPattern(), MDY_DASH.getPattern(), MDY_PERIOD.getPattern(), MDY_SLASH.getPattern());
            List<String> list2 = Arrays.asList(YMD_DASH.getPattern(), YMD_PERIOD.getPattern(), YMD_SLASH.getPattern());
            if (list.contains(string4)) {
                string4 = string4.substring(0, string4.indexOf("yyyy") - 1);
            } else if (list2.contains(string4)) {
                string4 = string4.substring("yyyy".length() + 1);
            } else {
                throw new IllegalArgumentException();
            }
        }
        return string4.replace("MM", StringHelper.leftPad((String)string2, (int)2, (char)'0')).replace("dd", StringHelper.leftPad((String)string3, (int)2, (char)'0'));
    }
}

