/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.system.fields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.fields.CustomFieldControl;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum CustomFieldType implements HasMessageKey
{
    STRING(CustomFieldControl.TEXT),
    TEXT(CustomFieldControl.TEXTAREA),
    RICH_TEXT(CustomFieldControl.RICH_EDITOR),
    SINGLE_SELECTION(CustomFieldControl.SINGLE_SELECTION, CustomFieldControl.RADIO),
    MULTI_SELECTION(CustomFieldControl.MULTI_SELECTION, CustomFieldControl.CHECKBOX),
    DYNAMIC_SELECTION(CustomFieldControl.SINGLE_SELECTION, CustomFieldControl.RADIO),
    DYNAMIC_MULTI_SELECTION(CustomFieldControl.MULTI_SELECTION, CustomFieldControl.CHECKBOX),
    INTEGER(CustomFieldControl.TEXT),
    DECIMAL(CustomFieldControl.TEXT),
    DATE(CustomFieldControl.TEXT),
    BOOLEAN(CustomFieldControl.CHECKBOX),
    URL(CustomFieldControl.TEXT),
    LINKED_ENTITY(CustomFieldControl.ENTITY_SELECTION),
    FILE(CustomFieldControl.UPLOAD),
    IMAGE(CustomFieldControl.UPLOAD);

    private final List<CustomFieldControl> possibleControls;

    private CustomFieldType(CustomFieldControl ... customFieldControlArray) {
        this.possibleControls = Collections.unmodifiableList(Arrays.asList(customFieldControlArray));
    }

    public boolean canHaveLoadValuesScript() {
        return this != BOOLEAN && this != TEXT && this != RICH_TEXT && !this.isBinary();
    }

    public boolean canHaveValuesOnSearch() {
        return this == LINKED_ENTITY || this.isDynamic() || this.isEnumerated();
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return SystemKeys.Fields.TYPE_STRING;
            }
            case 1: {
                return SystemKeys.Fields.TYPE_TEXT;
            }
            case 2: {
                return SystemKeys.Fields.TYPE_RICH_TEXT;
            }
            case 3: {
                return SystemKeys.Fields.TYPE_SINGLE_SELECTION;
            }
            case 4: {
                return SystemKeys.Fields.TYPE_MULTI_SELECTION;
            }
            case 5: {
                return SystemKeys.Fields.TYPE_DYNAMIC_SELECTION;
            }
            case 6: {
                return SystemKeys.Fields.TYPE_DYNAMIC_MULTI_SELECTION;
            }
            case 7: {
                return SystemKeys.Fields.TYPE_INTEGER;
            }
            case 8: {
                return SystemKeys.Fields.TYPE_DECIMAL;
            }
            case 9: {
                return SystemKeys.Fields.TYPE_DATE;
            }
            case 10: {
                return SystemKeys.Fields.TYPE_BOOLEAN;
            }
            case 11: {
                return SystemKeys.Fields.TYPE_URL;
            }
            case 12: {
                return SystemKeys.Fields.TYPE_LINKED_ENTITY;
            }
            case 13: {
                return SystemKeys.Fields.TYPE_FILE;
            }
            case 14: {
                return SystemKeys.Fields.TYPE_IMAGE;
            }
        }
        return null;
    }

    public List<CustomFieldControl> getPossibleControls(boolean bl) {
        if (this == MULTI_SELECTION || this == DYNAMIC_MULTI_SELECTION) {
            return this.possibleControls;
        }
        if (bl) {
            return CustomFieldType.DYNAMIC_SELECTION.possibleControls;
        }
        return this.possibleControls;
    }

    public boolean hasMultipleValues() {
        return this == MULTI_SELECTION || this == DYNAMIC_MULTI_SELECTION || this.isBinary();
    }

    public boolean isAllowedToBeOnResultList() {
        return !this.isBinary() && this != MULTI_SELECTION && this != DYNAMIC_MULTI_SELECTION;
    }

    public boolean isAllowedToBeOnSearchFilters() {
        return !this.isBinary();
    }

    public boolean isBinary() {
        return this == FILE || this == IMAGE;
    }

    public boolean isDynamic() {
        return this == DYNAMIC_SELECTION || this == DYNAMIC_MULTI_SELECTION;
    }

    public boolean isEnumerated() {
        return this == SINGLE_SELECTION || this == MULTI_SELECTION;
    }

    public boolean isSearchable() {
        return this.isString() && this != URL;
    }

    public boolean isSingleString() {
        return this == STRING || this == URL;
    }

    public boolean isSortable() {
        return this.isString() || this == BOOLEAN || this == DATE || this == INTEGER || this == DECIMAL || this == DYNAMIC_SELECTION || this == SINGLE_SELECTION;
    }

    public boolean isString() {
        return this == STRING || this == TEXT || this == RICH_TEXT || this == URL;
    }

    public boolean isUseSize(CustomFieldControl customFieldControl) {
        if (this == STRING || this == URL || this.isEnumerated() || this.isDynamic()) {
            return customFieldControl == null || customFieldControl.isUseSize();
        }
        return false;
    }
}

