/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.system.exportformats;

import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.exportformats.ExportFormatContext;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum BuiltInExportFormat implements HasMessageKey
{
    CSV("csv", "CSV", false, "text/csv", "csv", ExportFormatContext::isTabular),
    XLSX("xlsx", "Excel (xlsx)", true, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx", ExportFormatContext::isTabular),
    PDF("pdf", "PDF", true, "application/pdf", "pdf", ExportFormatContext::isPdf);

    private final String internalName;
    private final String displayName;
    private final boolean binary;
    private final String contentType;
    private final String fileExtension;
    private final Set<ExportFormatContext> contexts;

    public static BuiltInExportFormat getByInternalName(String string) {
        for (BuiltInExportFormat builtInExportFormat : BuiltInExportFormat.values()) {
            if (!builtInExportFormat.internalName.equals(string)) continue;
            return builtInExportFormat;
        }
        return null;
    }

    private BuiltInExportFormat(String string2, String string3, boolean bl, String string4, String string5, Predicate<ExportFormatContext> predicate) {
        this.internalName = string2;
        this.displayName = string3;
        this.binary = bl;
        this.contentType = string4;
        this.fileExtension = string5;
        this.contexts = Collections.unmodifiableSet(Stream.of(ExportFormatContext.values()).filter(predicate).collect(Collectors.toSet()));
    }

    public String getContentType() {
        return this.contentType;
    }

    public Set<ExportFormatContext> getContexts() {
        return this.contexts;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getInternalName() {
        return this.internalName;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return GeneralKeys.InitialData.EXPORT_FORMAT_CSV;
            }
            case 1: {
                return GeneralKeys.InitialData.EXPORT_FORMAT_XLSX;
            }
            case 2: {
                return GeneralKeys.InitialData.EXPORT_FORMAT_PDF;
            }
        }
        return null;
    }

    public boolean isBinary() {
        return this.binary;
    }
}

