/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.system.configurations;

import java.util.Collection;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;

public enum FormatSeparator {
    FORWARD_SLASH(" / "),
    DASH(" - "),
    UNDERSCORE(" _ "),
    PIPE(" | "),
    COMMA(", "),
    PERIOD(" . "),
    GREATER_THAN(" > "),
    DOUBLE_COLON(" :: "),
    PARENTHESIS(" (", ")"),
    ANGLED_BRACKETS(" <", ">"),
    CURLY_BRACES(" {", "}"),
    SQUARE_BRACKETS(" [", "]");

    private final String prefix;
    private final String suffix;

    private FormatSeparator(String string2) {
        this.prefix = string2;
        this.suffix = null;
    }

    private FormatSeparator(String string2, String string3) {
        this.prefix = string2;
        this.suffix = string3;
    }

    public String apply(Collection<String> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return null;
        }
        if (this.isBetween()) {
            return StringHelper.join(collection, (String)this.getSeparator());
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        boolean bl2 = false;
        for (String string : collection) {
            if (bl) {
                bl = false;
            } else if (!bl2) {
                bl2 = true;
                stringBuilder.append(this.prefix);
            } else {
                stringBuilder.append(FormatSeparator.COMMA.prefix);
            }
            stringBuilder.append(string);
        }
        if (bl2) {
            stringBuilder.append(this.suffix);
        }
        return stringBuilder.toString();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSeparator() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean isAround() {
        return this.suffix != null;
    }

    public boolean isBetween() {
        return this.suffix == null;
    }

    public String toString() {
        return StringHelper.trim((Object)this.getPrefix()) + StringHelper.trim((Object)this.getSuffix());
    }
}

