/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.messaging.notifications;

import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.messaging.notifications.INotificationType;
import org.cyclos.model.messaging.notifications.NotificationEntityType;
import org.cyclos.utils.EnumMessageKeyResolver;
import org.cyclos.utils.MessageKey;

public enum AdminNotificationType implements INotificationType
{
    APPLICATION_ERROR,
    AD_PENDING_AUTHORIZATION,
    NETWORK_CREATED,
    PAYMENT_PERFORMED,
    PAYMENT_AWAITING_AUTHORIZATION,
    EXTERNAL_PAYMENT_PERFORMED_FAILED,
    EXTERNAL_PAYMENT_EXPIRED,
    GENERATED_VOUCHERS_ABOUT_TO_EXPIRE,
    GENERATED_VOUCHERS_EXPIRED,
    VOUCHER_BUYING_ABOUT_TO_EXPIRE,
    USER_REGISTRATION,
    USER_IMPORT_REGISTRATION,
    USER_ALERT,
    SYSTEM_ALERT;

    public static final String PREFIX = "ADMIN";
    private static EnumMessageKeyResolver<AdminNotificationType> resolverForSms;
    private static EnumMessageKeyResolver<AdminNotificationType> resolverForText;
    private static EnumMessageKeyResolver<AdminNotificationType> resolverForSettings;

    public static EnumMessageKeyResolver<AdminNotificationType> resolverForSettings() {
        if (resolverForSettings == null) {
            resolverForSettings = adminNotificationType -> {
                switch (adminNotificationType.ordinal()) {
                    case 0: {
                        return MessagingKeys.NotificationSettings.ADMIN_APPLICATION_ERROR;
                    }
                    case 1: {
                        return MessagingKeys.NotificationSettings.ADMIN_AD_PENDING_AUTHORIZATION;
                    }
                    case 2: {
                        return MessagingKeys.NotificationSettings.ADMIN_NETWORK_CREATED;
                    }
                    case 3: {
                        return MessagingKeys.NotificationSettings.ADMIN_PAYMENT_PERFORMED;
                    }
                    case 4: {
                        return MessagingKeys.NotificationSettings.ADMIN_PAYMENT_AWAITING_AUTHORIZATION;
                    }
                    case 5: {
                        return MessagingKeys.NotificationSettings.ADMIN_EXTERNAL_PAYMENT_PERFORMED_FAILED;
                    }
                    case 6: {
                        return MessagingKeys.NotificationSettings.ADMIN_EXTERNAL_PAYMENT_EXPIRED;
                    }
                    case 7: {
                        return MessagingKeys.NotificationSettings.ADMIN_GENERATED_VOUCHERS_ABOUT_TO_EXPIRE;
                    }
                    case 8: {
                        return MessagingKeys.NotificationSettings.ADMIN_GENERATED_VOUCHERS_EXPIRED;
                    }
                    case 9: {
                        return MessagingKeys.NotificationSettings.ADMIN_VOUCHER_BUYING_ABOUT_TO_EXPIRE;
                    }
                    case 10: {
                        return MessagingKeys.NotificationSettings.ADMIN_USER_REGISTRATION;
                    }
                    case 11: {
                        return null;
                    }
                    case 12: {
                        return MessagingKeys.NotificationSettings.ADMIN_USER_ALERT;
                    }
                    case 13: {
                        return MessagingKeys.NotificationSettings.ADMIN_SYSTEM_ALERT;
                    }
                }
                return null;
            };
        }
        return resolverForSettings;
    }

    public static EnumMessageKeyResolver<AdminNotificationType> resolverForSms() {
        if (resolverForSms == null) {
            resolverForSms = adminNotificationType -> {
                switch (adminNotificationType.ordinal()) {
                    case 0: {
                        return MessagingKeys.Notifications.ADMIN_APPLICATION_ERROR_SMS;
                    }
                    case 1: {
                        return MessagingKeys.Notifications.ADMIN_AD_PENDING_AUTHORIZATION_SMS;
                    }
                    case 2: {
                        return MessagingKeys.Notifications.ADMIN_NETWORK_CREATED_SMS;
                    }
                    case 3: {
                        return MessagingKeys.Notifications.ADMIN_PAYMENT_PERFORMED_SMS;
                    }
                    case 4: {
                        return MessagingKeys.Notifications.ADMIN_PAYMENT_AWAITING_AUTHORIZATION_SMS;
                    }
                    case 5: {
                        return MessagingKeys.Notifications.ADMIN_EXTERNAL_PAYMENT_PERFORMED_FAILED_SMS;
                    }
                    case 6: {
                        return MessagingKeys.Notifications.ADMIN_EXTERNAL_PAYMENT_EXPIRED_SMS;
                    }
                    case 7: {
                        return MessagingKeys.Notifications.ADMIN_GENERATED_VOUCHERS_ABOUT_TO_EXPIRE_SMS;
                    }
                    case 8: {
                        return MessagingKeys.Notifications.ADMIN_GENERATED_VOUCHERS_EXPIRED_SMS;
                    }
                    case 9: {
                        return MessagingKeys.Notifications.ADMIN_VOUCHER_BUYING_ABOUT_TO_EXPIRE_SMS;
                    }
                    case 10: {
                        return MessagingKeys.Notifications.ADMIN_USER_REGISTRATION_SMS;
                    }
                    case 11: {
                        return MessagingKeys.Notifications.ADMIN_USER_IMPORT_REGISTRATION_SMS;
                    }
                    case 12: {
                        return MessagingKeys.Notifications.ADMIN_USER_ALERT_SMS;
                    }
                    case 13: {
                        return MessagingKeys.Notifications.ADMIN_SYSTEM_ALERT_SMS;
                    }
                }
                return null;
            };
        }
        return resolverForSms;
    }

    public static EnumMessageKeyResolver<AdminNotificationType> resolverForText() {
        if (resolverForText == null) {
            resolverForText = adminNotificationType -> {
                switch (adminNotificationType.ordinal()) {
                    case 0: {
                        return MessagingKeys.Notifications.ADMIN_APPLICATION_ERROR_TEXT;
                    }
                    case 1: {
                        return MessagingKeys.Notifications.ADMIN_AD_PENDING_AUTHORIZATION_TEXT;
                    }
                    case 2: {
                        return MessagingKeys.Notifications.ADMIN_NETWORK_CREATED_TEXT;
                    }
                    case 3: {
                        return MessagingKeys.Notifications.ADMIN_PAYMENT_PERFORMED_TEXT;
                    }
                    case 4: {
                        return MessagingKeys.Notifications.ADMIN_PAYMENT_AWAITING_AUTHORIZATION_TEXT;
                    }
                    case 5: {
                        return MessagingKeys.Notifications.ADMIN_EXTERNAL_PAYMENT_PERFORMED_FAILED_TEXT;
                    }
                    case 6: {
                        return MessagingKeys.Notifications.ADMIN_EXTERNAL_PAYMENT_EXPIRED_TEXT;
                    }
                    case 7: {
                        return MessagingKeys.Notifications.ADMIN_GENERATED_VOUCHERS_ABOUT_TO_EXPIRE_TEXT;
                    }
                    case 8: {
                        return MessagingKeys.Notifications.ADMIN_GENERATED_VOUCHERS_EXPIRED_TEXT;
                    }
                    case 9: {
                        return MessagingKeys.Notifications.ADMIN_VOUCHER_BUYING_ABOUT_TO_EXPIRE_TEXT;
                    }
                    case 10: {
                        return MessagingKeys.Notifications.ADMIN_USER_REGISTRATION_TEXT;
                    }
                    case 11: {
                        return MessagingKeys.Notifications.ADMIN_USER_IMPORT_REGISTRATION_TEXT;
                    }
                    case 12: {
                        return MessagingKeys.Notifications.ADMIN_USER_ALERT_TEXT;
                    }
                    case 13: {
                        return MessagingKeys.Notifications.ADMIN_SYSTEM_ALERT_TEXT;
                    }
                }
                return null;
            };
        }
        return resolverForText;
    }

    @Override
    public MessageKey getKeyForSms() {
        return AdminNotificationType.resolverForSms().resolveKey(this);
    }

    @Override
    public MessageKey getKeyForText() {
        return AdminNotificationType.resolverForText().resolveKey(this);
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return MessagingKeys.Notifications.ADMIN_APPLICATION_ERROR;
            }
            case 1: {
                return MessagingKeys.Notifications.ADMIN_AD_PENDING_AUTHORIZATION;
            }
            case 2: {
                return MessagingKeys.Notifications.ADMIN_NETWORK_CREATED;
            }
            case 3: {
                return MessagingKeys.Notifications.ADMIN_PAYMENT_PERFORMED;
            }
            case 4: {
                return MessagingKeys.Notifications.ADMIN_PAYMENT_AWAITING_AUTHORIZATION;
            }
            case 5: {
                return MessagingKeys.Notifications.ADMIN_EXTERNAL_PAYMENT_PERFORMED_FAILED;
            }
            case 6: {
                return MessagingKeys.Notifications.ADMIN_EXTERNAL_PAYMENT_EXPIRED;
            }
            case 7: {
                return MessagingKeys.Notifications.ADMIN_GENERATED_VOUCHERS_ABOUT_TO_EXPIRE;
            }
            case 8: {
                return MessagingKeys.Notifications.ADMIN_GENERATED_VOUCHERS_EXPIRED;
            }
            case 9: {
                return MessagingKeys.Notifications.ADMIN_VOUCHER_BUYING_ABOUT_TO_EXPIRE;
            }
            case 10: {
                return MessagingKeys.Notifications.ADMIN_USER_REGISTRATION;
            }
            case 11: {
                return MessagingKeys.Notifications.ADMIN_USER_IMPORT_REGISTRATION;
            }
            case 12: {
                return MessagingKeys.Notifications.ADMIN_USER_ALERT;
            }
            case 13: {
                return MessagingKeys.Notifications.ADMIN_SYSTEM_ALERT;
            }
        }
        return null;
    }

    @Override
    public NotificationEntityType getNotificationEntityType() {
        switch (this.ordinal()) {
            case 1: {
                return NotificationEntityType.MARKETPLACE;
            }
            case 0: {
                return NotificationEntityType.ERROR_LOG;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return NotificationEntityType.TRANSACTION;
            }
            case 7: 
            case 8: {
                return NotificationEntityType.VOUCHER;
            }
            case 2: {
                return NotificationEntityType.NETWORK;
            }
            case 13: {
                return NotificationEntityType.SYSTEM_ALERT;
            }
            case 12: {
                return NotificationEntityType.USER_ALERT;
            }
            case 11: {
                return NotificationEntityType.USER_IMPORTED_FILE;
            }
            case 10: {
                return NotificationEntityType.USER;
            }
            case 9: {
                return NotificationEntityType.VOUCHER_TYPE;
            }
        }
        return null;
    }

    public String prefix() {
        return PREFIX;
    }
}

