/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.messaging.alerts;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.messaging.alerts.AlertType;
import org.cyclos.utils.EnumMessageKeyResolver;
import org.cyclos.utils.MessageKey;

public enum SystemAlertType implements AlertType
{
    APPLICATION_RESTARTED(true),
    ACCOUNT_BALANCE_FIXED,
    ARCHIVING_FAILED(true),
    INCONSISTENT_DB_SCHEMA(true),
    INCONSISTENT_BALANCE_BELOW_LIMIT,
    MAX_INCORRECT_LOGIN_ATTEMPTS,
    MAX_BLOCKED_USERS_REACHED,
    MAX_GLOBAL_SMS_REACHED,
    ACCOUNT_FEE_CHARGED_NO_FAILURES,
    ACCOUNT_FEE_CHARGED_WITH_FAILURES,
    PARTIAL_DATA_RETURNED(10),
    SMS_SENDING_FAILED(1),
    EMAIL_SENDING_FAILED(10),
    CUSTOM_TRANSLATIONS_INVALIDATED,
    MAX_USERS_ALMOST_REACHED(true),
    CUSTOM;

    private static EnumMessageKeyResolver<SystemAlertType> resolverForText;
    private final boolean global;
    private final Integer minMinutes;

    public static List<SystemAlertType> networkedTypes() {
        return Stream.of(SystemAlertType.values()).filter(systemAlertType -> !systemAlertType.isGlobal()).collect(Collectors.toList());
    }

    public static EnumMessageKeyResolver<SystemAlertType> resolverForText() {
        if (resolverForText == null) {
            resolverForText = systemAlertType -> {
                switch (systemAlertType.ordinal()) {
                    case 1: {
                        return MessagingKeys.Alerts.SYSTEM_ACCOUNT_BALANCE_FIXED_TEXT;
                    }
                    case 8: {
                        return MessagingKeys.Alerts.SYSTEM_ACCOUNT_FEE_CHARGED_NO_FAILURES_TEXT;
                    }
                    case 9: {
                        return MessagingKeys.Alerts.SYSTEM_ACCOUNT_FEE_CHARGED_WITH_FAILURES_TEXT;
                    }
                    case 0: {
                        return MessagingKeys.Alerts.SYSTEM_APPLICATION_RESTARTED_TEXT;
                    }
                    case 2: {
                        return MessagingKeys.Alerts.SYSTEM_ARCHIVING_FAILED_TEXT;
                    }
                    case 15: {
                        return MessagingKeys.Alerts.SYSTEM_CUSTOM_TEXT;
                    }
                    case 12: {
                        return MessagingKeys.Alerts.SYSTEM_EMAIL_SENDING_FAILED_TEXT;
                    }
                    case 10: {
                        return MessagingKeys.Alerts.SYSTEM_PARTIAL_DATA_RETURNED_TEXT;
                    }
                    case 6: {
                        return MessagingKeys.Alerts.SYSTEM_MAX_BLOCKED_USERS_REACHED_TEXT;
                    }
                    case 5: {
                        return MessagingKeys.Alerts.SYSTEM_MAX_INCORRECT_LOGIN_ATTEMPTS_TEXT;
                    }
                    case 7: {
                        return MessagingKeys.Alerts.SYSTEM_MAX_GLOBAL_SMS_REACHED_TEXT;
                    }
                    case 11: {
                        return MessagingKeys.Alerts.SYSTEM_SMS_SENDING_FAILED_TEXT;
                    }
                    case 3: {
                        return MessagingKeys.Alerts.SYSTEM_INCONSISTENT_DB_SCHEMA_TEXT;
                    }
                    case 4: {
                        return MessagingKeys.Alerts.SYSTEM_INCONSISTENT_BALANCE_BELOW_LIMIT_TEXT;
                    }
                    case 13: {
                        return MessagingKeys.Alerts.SYSTEM_CUSTOM_TRANSLATIONS_INVALIDATED_TEXT;
                    }
                    case 14: {
                        return MessagingKeys.Alerts.SYSTEM_MAX_USERS_ALMOST_REACHED_TEXT;
                    }
                }
                return null;
            };
        }
        return resolverForText;
    }

    private SystemAlertType() {
        this(false, null);
    }

    private SystemAlertType(boolean bl) {
        this(bl, null);
    }

    private SystemAlertType(boolean bl, Integer n2) {
        this.global = bl;
        this.minMinutes = n2;
    }

    private SystemAlertType(Integer n2) {
        this(false, n2);
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 1: {
                return MessagingKeys.Alerts.SYSTEM_ACCOUNT_BALANCE_FIXED;
            }
            case 8: {
                return MessagingKeys.Alerts.SYSTEM_ACCOUNT_FEE_CHARGED_NO_FAILURES;
            }
            case 9: {
                return MessagingKeys.Alerts.SYSTEM_ACCOUNT_FEE_CHARGED_WITH_FAILURES;
            }
            case 0: {
                return MessagingKeys.Alerts.SYSTEM_APPLICATION_RESTARTED;
            }
            case 2: {
                return MessagingKeys.Alerts.SYSTEM_ARCHIVING_FAILED;
            }
            case 15: {
                return MessagingKeys.Alerts.SYSTEM_CUSTOM;
            }
            case 12: {
                return MessagingKeys.Alerts.SYSTEM_EMAIL_SENDING_FAILED;
            }
            case 10: {
                return MessagingKeys.Alerts.SYSTEM_PARTIAL_DATA_RETURNED;
            }
            case 6: {
                return MessagingKeys.Alerts.SYSTEM_MAX_BLOCKED_USERS_REACHED;
            }
            case 5: {
                return MessagingKeys.Alerts.SYSTEM_MAX_INCORRECT_LOGIN_ATTEMPTS;
            }
            case 7: {
                return MessagingKeys.Alerts.SYSTEM_MAX_GLOBAL_SMS_REACHED;
            }
            case 11: {
                return MessagingKeys.Alerts.SYSTEM_SMS_SENDING_FAILED;
            }
            case 3: {
                return MessagingKeys.Alerts.SYSTEM_INCONSISTENT_DB_SCHEMA;
            }
            case 4: {
                return MessagingKeys.Alerts.SYSTEM_INCONSISTENT_BALANCE_BELOW_LIMIT;
            }
            case 13: {
                return MessagingKeys.Alerts.SYSTEM_CUSTOM_TRANSLATIONS_INVALIDATED;
            }
            case 14: {
                return MessagingKeys.Alerts.SYSTEM_MAX_USERS_ALMOST_REACHED;
            }
        }
        return null;
    }

    public Integer getMinMinutes() {
        return this.minMinutes;
    }

    public boolean isGlobal() {
        return this.global;
    }

    @Override
    public MessageKey keyForText() {
        return SystemAlertType.resolverForText().resolveKey(this);
    }
}

