/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.contentmanagement.translations;

import java.util.EnumSet;
import java.util.Set;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.contentmanagement.translations.DataTranslationTypeGroup;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum DataTranslationType implements HasMessageKey
{
    CONFIGURATION(DataTranslationTypeGroup.SYSTEM_CONFIGURATION),
    CHANNEL(DataTranslationTypeGroup.SYSTEM_CONFIGURATION),
    EXPORT_FORMAT(DataTranslationTypeGroup.SYSTEM_CONFIGURATION),
    PRINCIPAL_TYPE(DataTranslationTypeGroup.SYSTEM_CONFIGURATION),
    PASSWORD_TYPE(DataTranslationTypeGroup.SYSTEM_CONFIGURATION),
    CURRENCIES(DataTranslationTypeGroup.ACCOUNT_CONFIGURATION),
    ACCOUNT_TYPES(DataTranslationTypeGroup.ACCOUNT_CONFIGURATION),
    TRANSFER_TYPES(DataTranslationTypeGroup.ACCOUNT_CONFIGURATION),
    TRANSFER_FILTERS(DataTranslationTypeGroup.ACCOUNT_CONFIGURATION),
    ACCOUNT_FEES(DataTranslationTypeGroup.ACCOUNT_CONFIGURATION),
    TRANSFER_FEES(DataTranslationTypeGroup.ACCOUNT_CONFIGURATION),
    TRANSACTION_FIELDS(DataTranslationTypeGroup.ACCOUNT_CONFIGURATION),
    TRANSACTION_FIELD_POSSIBLE_VALUES(DataTranslationTypeGroup.ACCOUNT_CONFIGURATION),
    TRANSACTION_FIELD_POSSIBLE_VALUE_CATEGORIES(DataTranslationTypeGroup.ACCOUNT_CONFIGURATION),
    TRANSFER_STATUS_FLOWS(DataTranslationTypeGroup.ACCOUNT_CONFIGURATION),
    TRANSFER_STATUSES(DataTranslationTypeGroup.ACCOUNT_CONFIGURATION),
    VOUCHER_CONFIGURATIONS(DataTranslationTypeGroup.ACCOUNT_CONFIGURATION),
    VOUCHER_CATEGORIES(DataTranslationTypeGroup.ACCOUNT_CONFIGURATION),
    VOUCHER_TYPES(DataTranslationTypeGroup.ACCOUNT_CONFIGURATION),
    VOUCHER_FIELDS(DataTranslationTypeGroup.ACCOUNT_CONFIGURATION),
    VOUCHER_FIELD_POSSIBLE_VALUES(DataTranslationTypeGroup.ACCOUNT_CONFIGURATION),
    VOUCHER_FIELD_POSSIBLE_VALUE_CATEGORIES(DataTranslationTypeGroup.ACCOUNT_CONFIGURATION),
    GROUPS(DataTranslationTypeGroup.USER_CONFIGURATION),
    PRODUCTS(DataTranslationTypeGroup.USER_CONFIGURATION),
    IDENTITY_PROVIDER(DataTranslationTypeGroup.USER_CONFIGURATION),
    PROFILE_FIELDS(DataTranslationTypeGroup.USER_CONFIGURATION),
    PROFILE_FIELD_POSSIBLE_VALUES(DataTranslationTypeGroup.USER_CONFIGURATION),
    PROFILE_FIELD_POSSIBLE_VALUE_CATEGORIES(DataTranslationTypeGroup.USER_CONFIGURATION),
    PRIVACY_CONTROLS(DataTranslationTypeGroup.USER_CONFIGURATION),
    CONTACT_FIELDS(DataTranslationTypeGroup.USER_CONFIGURATION),
    CONTACT_FIELD_POSSIBLE_VALUES(DataTranslationTypeGroup.USER_CONFIGURATION),
    CONTACT_FIELD_POSSIBLE_VALUE_CATEGORIES(DataTranslationTypeGroup.USER_CONFIGURATION),
    CONTACT_INFO_FIELDS(DataTranslationTypeGroup.USER_CONFIGURATION),
    CONTACT_INFO_FIELD_POSSIBLE_VALUES(DataTranslationTypeGroup.USER_CONFIGURATION),
    CONTACT_INFO_FIELD_POSSIBLE_VALUE_CATEGORIES(DataTranslationTypeGroup.USER_CONFIGURATION),
    AD_CATEGORIES(DataTranslationTypeGroup.AD_CONFIGURATION),
    AD_FIELDS(DataTranslationTypeGroup.AD_CONFIGURATION),
    AD_FIELD_POSSIBLE_VALUES(DataTranslationTypeGroup.AD_CONFIGURATION),
    AD_FIELD_POSSIBLE_VALUE_CATEGORIES(DataTranslationTypeGroup.AD_CONFIGURATION),
    RECORD_TYPES(DataTranslationTypeGroup.RECORDS),
    RECORD_SECTIONS(DataTranslationTypeGroup.RECORDS),
    RECORD_FIELDS(DataTranslationTypeGroup.RECORDS),
    RECORD_FIELD_POSSIBLE_VALUES(DataTranslationTypeGroup.RECORDS),
    RECORD_FIELD_POSSIBLE_VALUE_CATEGORIES(DataTranslationTypeGroup.RECORDS),
    USER_SECTIONS(DataTranslationTypeGroup.USER_CONFIGURATION),
    STATIC_CONTENT(DataTranslationTypeGroup.CONTENT),
    MENU_ENTRIES(DataTranslationTypeGroup.CONTENT),
    BANNERS(DataTranslationTypeGroup.CONTENT),
    MOBILE_PAGES(DataTranslationTypeGroup.CONTENT),
    SMS_TEXTS(DataTranslationTypeGroup.CONTENT),
    MESSAGE_CATEGORIES(DataTranslationTypeGroup.CONTENT),
    DOCUMENTS(DataTranslationTypeGroup.CONTENT),
    DOCUMENT_FIELDS(DataTranslationTypeGroup.CONTENT),
    DOCUMENT_FIELD_POSSIBLE_VALUES(DataTranslationTypeGroup.CONTENT),
    DOCUMENT_FIELD_POSSIBLE_VALUE_CATEGORIES(DataTranslationTypeGroup.CONTENT),
    CUSTOM_OPERATIONS(DataTranslationTypeGroup.CUSTOM_OPERATIONS),
    CUSTOM_OPERATION_FIELDS(DataTranslationTypeGroup.CUSTOM_OPERATIONS),
    CUSTOM_OPERATION_FIELD_POSSIBLE_VALUES(DataTranslationTypeGroup.CUSTOM_OPERATIONS),
    CUSTOM_OPERATION_FIELD_POSSIBLE_VALUE_CATEGORIES(DataTranslationTypeGroup.CUSTOM_OPERATIONS),
    CUSTOM_WIZARDS(DataTranslationTypeGroup.CUSTOM_WIZARDS),
    CUSTOM_WIZARD_STEPS(DataTranslationTypeGroup.CUSTOM_WIZARDS),
    CUSTOM_WIZARD_FIELDS(DataTranslationTypeGroup.CUSTOM_WIZARDS),
    CUSTOM_WIZARD_FIELD_POSSIBLE_VALUES(DataTranslationTypeGroup.CUSTOM_WIZARDS),
    CUSTOM_WIZARD_FIELD_POSSIBLE_VALUE_CATEGORIES(DataTranslationTypeGroup.CUSTOM_WIZARDS);

    private final DataTranslationTypeGroup group;

    public static Set<DataTranslationType> getByGroup(DataTranslationTypeGroup dataTranslationTypeGroup) {
        EnumSet<DataTranslationType> enumSet = EnumSet.noneOf(DataTranslationType.class);
        for (DataTranslationType dataTranslationType : DataTranslationType.values()) {
            if (dataTranslationType.group != dataTranslationTypeGroup) continue;
            enumSet.add(dataTranslationType);
        }
        return enumSet;
    }

    private DataTranslationType(DataTranslationTypeGroup dataTranslationTypeGroup) {
        this.group = dataTranslationTypeGroup;
    }

    public DataTranslationTypeGroup getGroup() {
        return this.group;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 1: {
                return ContentManagementKeys.Translations.DATA_TYPE_CHANNEL;
            }
            case 0: {
                return ContentManagementKeys.Translations.DATA_TYPE_CONFIGURATION;
            }
            case 2: {
                return ContentManagementKeys.Translations.DATA_TYPE_EXPORT_FORMAT;
            }
            case 3: {
                return ContentManagementKeys.Translations.DATA_TYPE_PRINCIPAL_TYPE;
            }
            case 4: {
                return ContentManagementKeys.Translations.DATA_TYPE_PASSWORD_TYPE;
            }
            case 5: {
                return ContentManagementKeys.Translations.DATA_TYPE_CURRENCIES;
            }
            case 6: {
                return ContentManagementKeys.Translations.DATA_TYPE_ACCOUNT_TYPES;
            }
            case 7: {
                return ContentManagementKeys.Translations.DATA_TYPE_TRANSFER_TYPES;
            }
            case 8: {
                return ContentManagementKeys.Translations.DATA_TYPE_TRANSFER_FILTERS;
            }
            case 9: {
                return ContentManagementKeys.Translations.DATA_TYPE_ACCOUNT_FEES;
            }
            case 10: {
                return ContentManagementKeys.Translations.DATA_TYPE_TRANSFER_FEES;
            }
            case 11: {
                return ContentManagementKeys.Translations.DATA_TYPE_TRANSACTION_FIELDS;
            }
            case 12: {
                return ContentManagementKeys.Translations.DATA_TYPE_TRANSACTION_FIELD_POSSIBLE_VALUES;
            }
            case 13: {
                return ContentManagementKeys.Translations.DATA_TYPE_TRANSACTION_FIELD_POSSIBLE_VALUE_CATEGORIES;
            }
            case 14: {
                return ContentManagementKeys.Translations.DATA_TYPE_TRANSFER_STATUS_FLOWS;
            }
            case 15: {
                return ContentManagementKeys.Translations.DATA_TYPE_TRANSFER_STATUSES;
            }
            case 22: {
                return ContentManagementKeys.Translations.DATA_TYPE_GROUPS;
            }
            case 23: {
                return ContentManagementKeys.Translations.DATA_TYPE_PRODUCTS;
            }
            case 24: {
                return ContentManagementKeys.Translations.DATA_TYPE_IDENTITY_PROVIDER;
            }
            case 25: {
                return ContentManagementKeys.Translations.DATA_TYPE_PROFILE_FIELDS;
            }
            case 26: {
                return ContentManagementKeys.Translations.DATA_TYPE_PROFILE_FIELD_POSSIBLE_VALUES;
            }
            case 27: {
                return ContentManagementKeys.Translations.DATA_TYPE_PROFILE_FIELD_POSSIBLE_VALUE_CATEGORIES;
            }
            case 28: {
                return ContentManagementKeys.Translations.DATA_TYPE_PRIVACY_CONTROLS;
            }
            case 35: {
                return ContentManagementKeys.Translations.DATA_TYPE_AD_CATEGORIES;
            }
            case 36: {
                return ContentManagementKeys.Translations.DATA_TYPE_AD_FIELDS;
            }
            case 37: {
                return ContentManagementKeys.Translations.DATA_TYPE_AD_FIELD_POSSIBLE_VALUES;
            }
            case 38: {
                return ContentManagementKeys.Translations.DATA_TYPE_AD_FIELD_POSSIBLE_VALUE_CATEGORIES;
            }
            case 39: {
                return ContentManagementKeys.Translations.DATA_TYPE_RECORD_TYPES;
            }
            case 40: {
                return ContentManagementKeys.Translations.DATA_TYPE_RECORD_SECTIONS;
            }
            case 41: {
                return ContentManagementKeys.Translations.DATA_TYPE_RECORD_FIELDS;
            }
            case 42: {
                return ContentManagementKeys.Translations.DATA_TYPE_RECORD_FIELD_POSSIBLE_VALUES;
            }
            case 43: {
                return ContentManagementKeys.Translations.DATA_TYPE_RECORD_FIELD_POSSIBLE_VALUE_CATEGORIES;
            }
            case 45: {
                return ContentManagementKeys.Translations.DATA_TYPE_STATIC_CONTENT;
            }
            case 46: {
                return ContentManagementKeys.Translations.DATA_TYPE_MENU_ENTRIES;
            }
            case 47: {
                return ContentManagementKeys.Translations.DATA_TYPE_BANNERS;
            }
            case 48: {
                return ContentManagementKeys.Translations.DATA_TYPE_MOBILE_PAGES;
            }
            case 49: {
                return ContentManagementKeys.Translations.DATA_TYPE_SMS_TEXTS;
            }
            case 50: {
                return ContentManagementKeys.Translations.DATA_TYPE_MESSAGE_CATEGORIES;
            }
            case 55: {
                return ContentManagementKeys.Translations.DATA_TYPE_CUSTOM_OPERATIONS;
            }
            case 56: {
                return ContentManagementKeys.Translations.DATA_TYPE_CUSTOM_OPERATION_FIELDS;
            }
            case 57: {
                return ContentManagementKeys.Translations.DATA_TYPE_CUSTOM_OPERATION_FIELD_POSSIBLE_VALUES;
            }
            case 58: {
                return ContentManagementKeys.Translations.DATA_TYPE_CUSTOM_OPERATION_FIELD_POSSIBLE_VALUE_CATEGORIES;
            }
            case 59: {
                return ContentManagementKeys.Translations.DATA_TYPE_CUSTOM_WIZARDS;
            }
            case 60: {
                return ContentManagementKeys.Translations.DATA_TYPE_CUSTOM_WIZARD_STEPS;
            }
            case 61: {
                return ContentManagementKeys.Translations.DATA_TYPE_CUSTOM_WIZARD_FIELDS;
            }
            case 62: {
                return ContentManagementKeys.Translations.DATA_TYPE_CUSTOM_WIZARD_FIELD_POSSIBLE_VALUES;
            }
            case 63: {
                return ContentManagementKeys.Translations.DATA_TYPE_CUSTOM_WIZARD_FIELD_POSSIBLE_VALUE_CATEGORIES;
            }
            case 29: {
                return ContentManagementKeys.Translations.DATA_TYPE_CONTACT_FIELDS;
            }
            case 30: {
                return ContentManagementKeys.Translations.DATA_TYPE_CONTACT_FIELD_POSSIBLE_VALUES;
            }
            case 31: {
                return ContentManagementKeys.Translations.DATA_TYPE_CONTACT_FIELD_POSSIBLE_VALUE_CATEGORIES;
            }
            case 32: {
                return ContentManagementKeys.Translations.DATA_TYPE_CONTACT_INFO_FIELDS;
            }
            case 33: {
                return ContentManagementKeys.Translations.DATA_TYPE_CONTACT_INFO_FIELD_POSSIBLE_VALUES;
            }
            case 34: {
                return ContentManagementKeys.Translations.DATA_TYPE_CONTACT_INFO_FIELD_POSSIBLE_VALUE_CATEGORIES;
            }
            case 16: {
                return ContentManagementKeys.Translations.DATA_TYPE_VOUCHER_CONFIGURATIONS;
            }
            case 17: {
                return ContentManagementKeys.Translations.DATA_TYPE_VOUCHER_CATEGORIES;
            }
            case 18: {
                return ContentManagementKeys.Translations.DATA_TYPE_VOUCHER_TYPES;
            }
            case 19: {
                return ContentManagementKeys.Translations.DATA_TYPE_VOUCHER_FIELDS;
            }
            case 20: {
                return ContentManagementKeys.Translations.DATA_TYPE_VOUCHER_FIELD_POSSIBLE_VALUES;
            }
            case 21: {
                return ContentManagementKeys.Translations.DATA_TYPE_VOUCHER_FIELD_POSSIBLE_VALUE_CATEGORIES;
            }
            case 44: {
                return ContentManagementKeys.Translations.DATA_TYPE_USER_SECTIONS;
            }
            case 51: {
                return ContentManagementKeys.Translations.DATA_TYPE_DOCUMENTS;
            }
            case 52: {
                return ContentManagementKeys.Translations.DATA_TYPE_DOCUMENT_FIELDS;
            }
            case 53: {
                return ContentManagementKeys.Translations.DATA_TYPE_DOCUMENT_FIELD_POSSIBLE_VALUES;
            }
            case 54: {
                return ContentManagementKeys.Translations.DATA_TYPE_DOCUMENT_FIELD_POSSIBLE_VALUE_CATEGORIES;
            }
        }
        return null;
    }
}

