/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.contentmanagement.staticcontents;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.contentmanagement.staticcontents.StaticContentType;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum StaticContentNature implements HasMessageKey
{
    HEADER(StaticContentType.MAIN_WEB),
    FOOTER(StaticContentType.MAIN_WEB),
    LOGGED_USER_HOME(StaticContentType.MAIN_WEB),
    GUEST_HOME(StaticContentType.MAIN_WEB),
    ADMIN_HELP(StaticContentType.MAIN_WEB, true),
    USER_HELP(StaticContentType.MAIN_WEB, true),
    FRONTEND_HOME(StaticContentType.FRONTEND),
    FRONTEND_DASHBOARD(StaticContentType.FRONTEND),
    FRONTEND_FOOTER(StaticContentType.FRONTEND),
    FRONTEND_HELP(StaticContentType.FRONTEND),
    WELCOME(StaticContentType.MOBILE),
    HOME(StaticContentType.MOBILE),
    LOGIN_HEADER(StaticContentType.MOBILE),
    LOGIN_FOOTER(StaticContentType.MOBILE),
    MOBILE_HELP(StaticContentType.MOBILE, true),
    MOBILE_POS_HELP(StaticContentType.MOBILE, true),
    PAY_HEADER(StaticContentType.PAY),
    PAY_FOOTER(StaticContentType.PAY),
    EMAIL_TEMPLATE(StaticContentType.EMAIL_TEMPLATE);

    private StaticContentType type;
    private boolean isHelpContent;

    public static List<StaticContentNature> mobileNatures() {
        return Arrays.asList(StaticContentNature.values()).stream().filter(staticContentNature -> staticContentNature.type == StaticContentType.MOBILE).collect(Collectors.toList());
    }

    private StaticContentNature(StaticContentType staticContentType) {
        this(staticContentType, false);
    }

    private StaticContentNature(StaticContentType staticContentType, boolean bl) {
        this.type = staticContentType;
        this.isHelpContent = bl;
    }

    public boolean allowVariables() {
        return this == HEADER || this == FOOTER || this == LOGGED_USER_HOME || this == FRONTEND_DASHBOARD || this == FRONTEND_FOOTER || this == HOME || this == EMAIL_TEMPLATE;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return ContentManagementKeys.StaticContents.NATURE_HEADER;
            }
            case 1: {
                return ContentManagementKeys.StaticContents.NATURE_FOOTER;
            }
            case 2: {
                return ContentManagementKeys.StaticContents.NATURE_LOGGED_USER_HOME;
            }
            case 3: {
                return ContentManagementKeys.StaticContents.NATURE_GUEST_HOME;
            }
            case 4: {
                return ContentManagementKeys.StaticContents.NATURE_ADMIN_HELP;
            }
            case 5: {
                return ContentManagementKeys.StaticContents.NATURE_USER_HELP;
            }
            case 6: {
                return ContentManagementKeys.StaticContents.NATURE_FRONTEND_HOME;
            }
            case 7: {
                return ContentManagementKeys.StaticContents.NATURE_FRONTEND_DASHBOARD;
            }
            case 8: {
                return ContentManagementKeys.StaticContents.NATURE_FRONTEND_FOOTER;
            }
            case 9: {
                return ContentManagementKeys.StaticContents.NATURE_FRONTEND_HELP;
            }
            case 12: {
                return ContentManagementKeys.StaticContents.NATURE_LOGIN_HEADER;
            }
            case 13: {
                return ContentManagementKeys.StaticContents.NATURE_LOGIN_FOOTER;
            }
            case 14: {
                return ContentManagementKeys.StaticContents.NATURE_MOBILE_HELP;
            }
            case 15: {
                return ContentManagementKeys.StaticContents.NATURE_MOBILE_POS_HELP;
            }
            case 17: {
                return ContentManagementKeys.StaticContents.NATURE_PAY_FOOTER;
            }
            case 16: {
                return ContentManagementKeys.StaticContents.NATURE_PAY_HEADER;
            }
            case 18: {
                return ContentManagementKeys.StaticContents.NATURE_EMAIL_TEMPLATE;
            }
            case 10: {
                return ContentManagementKeys.StaticContents.NATURE_WELCOME;
            }
            case 11: {
                return ContentManagementKeys.StaticContents.NATURE_HOME;
            }
        }
        return null;
    }

    public boolean isHelpContent() {
        return this.isHelpContent;
    }

    public StaticContentType type() {
        return this.type;
    }
}

