/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.banking.transfertypes;

import java.util.Arrays;
import java.util.List;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum TransferTypeDirection implements HasMessageKey
{
    SYSTEM_TO_SYSTEM,
    SYSTEM_TO_USER,
    USER_TO_SYSTEM,
    USER_TO_USER,
    USER_TO_SELF;


    public static List<TransferTypeDirection> getSystemDirections(Boolean bl) {
        if (bl == null) {
            return Arrays.asList(SYSTEM_TO_SYSTEM, SYSTEM_TO_USER, USER_TO_SYSTEM);
        }
        if (bl.booleanValue()) {
            return Arrays.asList(SYSTEM_TO_SYSTEM, SYSTEM_TO_USER);
        }
        return Arrays.asList(SYSTEM_TO_SYSTEM, USER_TO_SYSTEM);
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return BankingKeys.TransferTypes.DIRECTION_SYSTEM_TO_SYSTEM;
            }
            case 1: {
                return BankingKeys.TransferTypes.DIRECTION_SYSTEM_TO_USER;
            }
            case 2: {
                return BankingKeys.TransferTypes.DIRECTION_USER_TO_SYSTEM;
            }
            case 3: {
                return BankingKeys.TransferTypes.DIRECTION_USER_TO_USER;
            }
            case 4: {
                return BankingKeys.TransferTypes.DIRECTION_USER_TO_SELF;
            }
        }
        return null;
    }

    public boolean isFromSystem() {
        return this == SYSTEM_TO_SYSTEM || this == SYSTEM_TO_USER;
    }

    public boolean isFromUser() {
        return !this.isFromSystem();
    }

    public boolean isToSystem() {
        return this == SYSTEM_TO_SYSTEM || this == USER_TO_SYSTEM;
    }

    public boolean isToUser() {
        return !this.isToSystem();
    }
}

