/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.banking.transactions;

public enum PaymentCreationType {
    DIRECT,
    POS,
    ORDER,
    REQUEST,
    EXTERNAL,
    TICKET,
    EASY_INVOICE,
    IMPORT,
    VOUCHER_BUYING,
    VOUCHER_REDEEMING,
    VOUCHER_TOP_UP,
    VOUCHER_REFUNDING;


    public boolean isCheckToOwner() {
        return this == TICKET || this == REQUEST || this == VOUCHER_REDEEMING || this == VOUCHER_REFUNDING;
    }

    public boolean isIgnoreChannelForPaymentType() {
        return this == REQUEST || this == EXTERNAL || this == TICKET || this == VOUCHER_BUYING || this == VOUCHER_REDEEMING || this == VOUCHER_TOP_UP || this == VOUCHER_REFUNDING;
    }

    public boolean isInverse() {
        return this == TICKET || this == EASY_INVOICE || this == REQUEST || this == VOUCHER_REDEEMING || this == VOUCHER_REFUNDING || this == POS;
    }

    public boolean isRequirePayer() {
        return this != TICKET && this != EASY_INVOICE;
    }

    public boolean isUseConfirmationPassword() {
        return this == DIRECT || this == POS || this == ORDER || this == REQUEST || this == EASY_INVOICE;
    }

    public boolean validateMinTimeBetweenPayments() {
        return this != IMPORT;
    }

    public boolean validatePaymentAmount() {
        return this != EXTERNAL && this != TICKET;
    }
}

