/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.access.oidcclients;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.GwtIncompatible;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;

public enum Scope implements HasMessageKey
{
    OPENID(true, new String[0]),
    PROFILE(true, new String[0]),
    EMAIL(true, new String[0]),
    PHONE(true, new String[0]),
    ADDRESS(true, new String[0]),
    OFFLINE_ACCESS(true, new String[0]),
    ACCOUNT_STATUS(false, "type"),
    ACCOUNT_HISTORY(false, "type"),
    PAYMENT(false, "to", "amount", "currency"),
    TICKETS(false, "to"),
    PROFILE_READ(false, new String[0]),
    PROFILE_WRITE(false, new String[0]),
    ADS_READ(false, new String[0]),
    ADS_WRITE(false, new String[0]),
    PURCHASE(false, new String[0]);

    public static List<String> NAMES;
    private static final List<String> OIDC_ONLY_SCOPES;
    private final String value = this.name().toLowerCase();
    private final boolean allowAdmins;
    private final List<String> parameters;

    public static boolean isOidc(String string) {
        return StringHelper.split((String)string, (String)" ").stream().allMatch(OIDC_ONLY_SCOPES::contains);
    }

    public static Scope of(String string) {
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        int n = string.indexOf(63);
        if (n > 0) {
            string = string.substring(0, n);
        }
        for (Scope scope : Scope.values()) {
            if (!scope.value.equals(string)) continue;
            return scope;
        }
        return null;
    }

    @GwtIncompatible
    public static Map<Scope, Map<String, String>> parse(String string) {
        return StringHelper.split((String)string, (String)" ").stream().map(Scope::parseWithParameters).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (map, map2) -> map, () -> new EnumMap(Scope.class)));
    }

    @GwtIncompatible
    private static Pair<Scope, Map<String, String>> parseWithParameters(String string) {
        Map map;
        Scope scope = Scope.of(string);
        if (scope == null) {
            throw new IllegalArgumentException("Invalid scope: " + string);
        }
        int n = string.indexOf(63);
        if (n > 0) {
            map = StringHelper.decodeQueryParameters((String)string.substring(n + 1));
            if (!map.isEmpty()) {
                TreeSet treeSet = new TreeSet(map.keySet());
                treeSet.removeAll(scope.getParameters());
                if (!treeSet.isEmpty()) {
                    throw new IllegalArgumentException("Invalid parameter " + (String)CollectionHelper.first(treeSet) + " for scope: " + scope.value);
                }
            }
        } else {
            map = Collections.emptyMap();
        }
        return Pair.create((Object)scope, map);
    }

    private Scope(boolean bl, String ... stringArray) {
        this.allowAdmins = bl;
        this.parameters = Collections.unmodifiableList(Arrays.asList(stringArray));
    }

    public boolean dependsOnOpenid() {
        return this == PROFILE || this == EMAIL || this == PHONE || this == ADDRESS;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return AccessKeys.OidcClients.SCOPES_OPENID;
            }
            case 1: {
                return AccessKeys.OidcClients.SCOPES_PROFILE;
            }
            case 2: {
                return AccessKeys.OidcClients.SCOPES_EMAIL;
            }
            case 3: {
                return AccessKeys.OidcClients.SCOPES_PHONE;
            }
            case 4: {
                return AccessKeys.OidcClients.SCOPES_ADDRESS;
            }
            case 5: {
                return AccessKeys.OidcClients.SCOPES_OFFLINE_ACCESS;
            }
            case 7: {
                return AccessKeys.OidcClients.SCOPES_ACCOUNT_HISTORY;
            }
            case 6: {
                return AccessKeys.OidcClients.SCOPES_ACCOUNT_STATUS;
            }
            case 8: {
                return AccessKeys.OidcClients.SCOPES_PAYMENT;
            }
            case 9: {
                return AccessKeys.OidcClients.SCOPES_TICKETS;
            }
            case 10: {
                return AccessKeys.OidcClients.SCOPES_PROFILE_READ;
            }
            case 11: {
                return AccessKeys.OidcClients.SCOPES_PROFILE_WRITE;
            }
            case 12: {
                return AccessKeys.OidcClients.SCOPES_ADS_READ;
            }
            case 13: {
                return AccessKeys.OidcClients.SCOPES_ADS_WRITE;
            }
            case 14: {
                return AccessKeys.OidcClients.SCOPES_PURCHASE;
            }
        }
        return null;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public boolean isAllowAdmins() {
        return this.allowAdmins;
    }

    public String toString() {
        return this.value;
    }

    static {
        NAMES = Collections.unmodifiableList(Stream.of(Scope.values()).map(Scope::toString).collect(Collectors.toList()));
        OIDC_ONLY_SCOPES = Stream.of(OPENID, PROFILE, EMAIL, PHONE, ADDRESS).map(Scope::toString).collect(Collectors.toList());
    }
}

