/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.access.devices;

import java.util.stream.Stream;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.LoginConfirmationField;
import org.cyclos.model.access.SecondaryLoginConfirmationField;
import org.cyclos.model.access.clients.AccessClientActionConfirmationField;
import org.cyclos.model.access.devices.ActivateTrustedDeviceConfirmationField;
import org.cyclos.model.access.devices.DeviceConfirmationField;
import org.cyclos.model.access.passwords.GenerateNewPasswordConfirmationField;
import org.cyclos.model.access.tokens.PersonalizeNfcTagConfirmationField;
import org.cyclos.model.access.totps.RemoveTotpSecretConfirmationField;
import org.cyclos.model.banking.accounts.ChangeAccountLimitsConfirmationField;
import org.cyclos.model.banking.transactions.ApproveTicketConfirmationField;
import org.cyclos.model.banking.transactions.ManageExternalPaymentConfirmationField;
import org.cyclos.model.banking.transactions.ManagePaymentRequestConfirmationField;
import org.cyclos.model.banking.transactions.ManageRecurringPaymentConfirmationField;
import org.cyclos.model.banking.transactions.ManageRecurringPaymentFailedOccurrenceConfirmationField;
import org.cyclos.model.banking.transactions.ManageScheduledPaymentConfirmationField;
import org.cyclos.model.banking.transactions.ManageScheduledPaymentInstallmentConfirmationField;
import org.cyclos.model.banking.transactions.ManageTransactionAuthorizationConfirmationField;
import org.cyclos.model.banking.transactions.PerformExternalPaymentConfirmationField;
import org.cyclos.model.banking.transactions.PerformPaymentConfirmationField;
import org.cyclos.model.banking.transfers.ChargebackConfirmationField;
import org.cyclos.model.banking.vouchers.BuyVouchersConfirmationField;
import org.cyclos.model.banking.vouchers.GenerateVouchersConfirmationField;
import org.cyclos.model.banking.vouchers.ManageVoucherConfirmationField;
import org.cyclos.model.banking.vouchers.SendVoucherConfirmationField;
import org.cyclos.model.banking.vouchers.TopUpVoucherConfirmationField;
import org.cyclos.model.marketplace.webshoporders.AcceptOrderConfirmationField;
import org.cyclos.model.marketplace.webshoporders.ShoppingCartCheckoutConfirmationField;
import org.cyclos.model.system.imports.ImportPaymentsConfirmationField;
import org.cyclos.model.system.imports.ImportUserPaymentsConfirmationField;
import org.cyclos.model.system.imports.ImportUserSendVouchersConfirmationField;
import org.cyclos.model.system.operations.RunCustomOperationConfirmationField;
import org.cyclos.model.system.wizards.RunCustomWizardConfirmationField;
import org.cyclos.model.users.addresses.ManageAddressConfirmationField;
import org.cyclos.model.users.contactinfos.ManageContactInfoConfirmationField;
import org.cyclos.model.users.phones.ManagePhoneConfirmationField;
import org.cyclos.model.users.records.ManageRecordConfirmationField;
import org.cyclos.model.users.users.EditProfileConfirmationField;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum DeviceConfirmationType implements HasMessageKey
{
    PERFORM_PAYMENT(PerformPaymentConfirmationField.values()),
    PERFORM_EXTERNAL_PAYMENT(PerformExternalPaymentConfirmationField.values()),
    MANAGE_EXTERNAL_PAYMENT(ManageExternalPaymentConfirmationField.values()),
    MANAGE_AUTHORIZATION(ManageTransactionAuthorizationConfirmationField.values()),
    MANAGE_SCHEDULED_PAYMENT(ManageScheduledPaymentConfirmationField.values()),
    MANAGE_RECURRING_PAYMENT(ManageRecurringPaymentConfirmationField.values()),
    MANAGE_PAYMENT_REQUEST(ManagePaymentRequestConfirmationField.values()),
    MANAGE_SCHEDULED_PAYMENT_INSTALLMENT(ManageScheduledPaymentInstallmentConfirmationField.values()),
    MANAGE_RECURRING_PAYMENT_FAILED_OCCURRENCE(ManageRecurringPaymentFailedOccurrenceConfirmationField.values()),
    ACCESS_CLIENT_ACTION(AccessClientActionConfirmationField.values()),
    EDIT_PROFILE(EditProfileConfirmationField.values()),
    MANAGE_PHONE(ManagePhoneConfirmationField.values()),
    MANAGE_ADDRESS(ManageAddressConfirmationField.values()),
    MANAGE_CONTACT_INFO(ManageContactInfoConfirmationField.values()),
    MANAGE_RECORD(ManageRecordConfirmationField.values()),
    SECONDARY_LOGIN(SecondaryLoginConfirmationField.values()),
    LOGIN(LoginConfirmationField.values()),
    SHOPPING_CART_CHECKOUT(ShoppingCartCheckoutConfirmationField.values()),
    ACCEPT_ORDER(AcceptOrderConfirmationField.values()),
    RUN_CUSTOM_OPERATION(RunCustomOperationConfirmationField.values()),
    RUN_CUSTOM_WIZARD(RunCustomWizardConfirmationField.values()),
    MANAGE_VOUCHER(ManageVoucherConfirmationField.values()),
    GENERATE_VOUCHERS(GenerateVouchersConfirmationField.values()),
    BUY_VOUCHERS(BuyVouchersConfirmationField.values()),
    TOP_UP_VOUCHER(TopUpVoucherConfirmationField.values()),
    SEND_VOUCHER(SendVoucherConfirmationField.values()),
    CHARGEBACK(ChargebackConfirmationField.values()),
    CHANGE_ACCOUNT_LIMITS(ChangeAccountLimitsConfirmationField.values()),
    GENERATE_NEW_PASSWORD(GenerateNewPasswordConfirmationField.values()),
    IMPORT_PAYMENTS(ImportPaymentsConfirmationField.values()),
    IMPORT_USER_PAYMENTS(ImportUserPaymentsConfirmationField.values()),
    IMPORT_USER_SEND_VOUCHERS(ImportUserSendVouchersConfirmationField.values()),
    APPROVE_TICKET(ApproveTicketConfirmationField.values()),
    PERSONALIZE_NFC_TAG(PersonalizeNfcTagConfirmationField.values()),
    MANAGE_TRUSTED_DEVICE(ActivateTrustedDeviceConfirmationField.values()),
    REMOVE_TOTP_SECRET(RemoveTotpSecretConfirmationField.values());

    private DeviceConfirmationField[] fields;

    private DeviceConfirmationType(DeviceConfirmationField[] deviceConfirmationFieldArray) {
        this.fields = deviceConfirmationFieldArray;
    }

    public DeviceConfirmationField[] fields() {
        return this.fields;
    }

    public DeviceConfirmationField findFieldByInputFieldName(String string) {
        return Stream.of(this.fields).filter(deviceConfirmationField -> deviceConfirmationField.inputFieldName().equals(string)).findFirst().get();
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_PERFORM_PAYMENT;
            }
            case 1: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_PERFORM_EXTERNAL_PAYMENT;
            }
            case 2: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_MANAGE_EXTERNAL_PAYMENT;
            }
            case 10: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_EDIT_PROFILE;
            }
            case 11: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_MANAGE_PHONE;
            }
            case 12: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_MANAGE_ADDRESS;
            }
            case 9: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_ACCESS_CLIENT_ACTION;
            }
            case 13: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_MANAGE_CONTACT_INFO;
            }
            case 3: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_MANAGE_AUTHORIZATION;
            }
            case 4: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_MANAGE_SCHEDULED_PAYMENT;
            }
            case 7: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_MANAGE_SCHEDULED_PAYMENT_INSTALLMENT;
            }
            case 6: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_MANAGE_PAYMENT_REQUEST;
            }
            case 14: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_MANAGE_RECORD;
            }
            case 15: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_SECONDARY_LOGIN;
            }
            case 16: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_LOGIN;
            }
            case 17: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_SHOPPING_CART_CHECKOUT;
            }
            case 18: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_ACCEPT_ORDER;
            }
            case 19: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_RUN_CUSTOM_OPERATION;
            }
            case 20: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_RUN_CUSTOM_WIZARD;
            }
            case 21: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_MANAGE_VOUCHER;
            }
            case 22: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_GENERATE_VOUCHERS;
            }
            case 23: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_BUY_VOUCHERS;
            }
            case 25: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_SEND_VOUCHER;
            }
            case 24: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_TOP_UP_VOUCHER;
            }
            case 26: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_CHARGEBACK;
            }
            case 27: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_CHANGE_ACCOUNT_LIMITS;
            }
            case 28: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_GENERATE_NEW_PASSWORD;
            }
            case 29: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_IMPORT_PAYMENTS;
            }
            case 30: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_IMPORT_USER_PAYMENTS;
            }
            case 31: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_IMPORT_USER_SEND_VOUCHERS;
            }
            case 32: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_APPROVE_TICKET;
            }
            case 5: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_MANAGE_RECURRING_PAYMENT;
            }
            case 8: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_MANAGE_RECURRING_PAYMENT_FAILED_OCCURRENCE;
            }
            case 33: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_PERSONALIZE_NFC_TAG;
            }
            case 34: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_MANAGE_TRUSTED_DEVICE;
            }
            case 35: {
                return AccessKeys.Devices.CONFIRMATION_TYPE_REMOVE_TOTP_SECRET;
            }
        }
        return null;
    }
}

