/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.access;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cyclos.model.access.PermissionAccountAccess;
import org.cyclos.model.access.PermissionUserAccess;
import org.cyclos.model.access.Role;
import org.cyclos.model.access.SecurityElement;

public enum Permission implements SecurityElement
{
    GLOBAL_CONFIGURATION_VIEW(Role.ADMIN),
    GLOBAL_CONFIGURATION_MANAGE(Role.ADMIN),
    NETWORKS_REGISTER(Role.ADMIN),
    SPECIFIC_NETWORKS_MANAGE(Role.ADMIN),
    SYSTEM_CONFIGURATION_VIEW(Role.ADMIN),
    SYSTEM_CONFIGURATION_MANAGE(Role.ADMIN),
    SPECIFIC_CONFIGURATION_MANAGE(Role.ADMIN),
    SPECIFIC_CONFIGURATION_MANAGE_CONTENT(Role.ADMIN),
    USER_CONFIGURATION_VIEW(Role.ADMIN),
    USER_CONFIGURATION_MANAGE(Role.ADMIN),
    ACCESSIBLE_GROUPS_VIEW(Role.ADMIN),
    ACCESSIBLE_GROUPS_MANAGE(Role.ADMIN),
    ACCOUNT_CONFIGURATION_VIEW(Role.ADMIN),
    ACCOUNT_CONFIGURATION_MANAGE(Role.ADMIN),
    ARCHIVED_ACCOUNTS_VIEW(Role.ADMIN),
    APPLICATION_TRANSLATION_ENABLE(Role.ADMIN),
    AD_CONFIGURATION_VIEW(Role.ADMIN),
    AD_CONFIGURATION_MANAGE(Role.ADMIN),
    MESSAGE_CATEGORIES_VIEW(Role.ADMIN),
    MESSAGE_CATEGORIES_MANAGE(Role.ADMIN),
    DOCUMENT_CATEGORY_VIEW(Role.ADMIN),
    DOCUMENT_CATEGORY_MANAGE(Role.ADMIN),
    SYSTEM_IMAGE_CATEGORY_VIEW(Role.ADMIN),
    SYSTEM_IMAGE_CATEGORY_MANAGE(Role.ADMIN),
    SYSTEM_ALERTS_VIEW(Role.ADMIN),
    ERROR_LOG_VIEW(Role.ADMIN),
    ERROR_LOG_MANAGE(Role.ADMIN),
    USER_ALERTS_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.ADMIN),
    SMS_MESSAGES_VIEW(Role.ADMIN),
    ENTITY_LOG_VIEW_CONFIGURATION(Role.ADMIN),
    ENTITY_LOG_VIEW_USER(Role.ADMIN),
    ACCESS_LOG_VIEW(Role.ADMIN),
    USERS_REGISTER(Role.MEMBER, Role.ADMIN, Role.BROKER),
    USERS_VIEW_HIDDEN_FIELDS(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    USERS_ACTIVE_CONFIGURATION_AND_PRODUCTS(Role.ADMIN, Role.BROKER),
    IMPORT_USERS(Role.ADMIN),
    IMPORT_ADS(Role.ADMIN),
    IMPORT_RECORDS(Role.ADMIN),
    IMPORT_GENERAL_REFERENCES(Role.ADMIN),
    IMPORT_PAYMENTS(Role.ADMIN),
    IMPORT_TRANSFERS(Role.ADMIN),
    IMPORT_TOKENS(Role.ADMIN),
    MY_IMPORTED_PAYMENTS_ENABLE(PermissionUserAccess.MY, Role.MEMBER),
    USER_IMPORTED_PAYMENTS_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_IMPORTED_PAYMENTS_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_GROUP_VIEW(PermissionUserAccess.MANAGEMENT_ANY, Role.ADMIN),
    USER_GROUP_MANAGE(PermissionUserAccess.MANAGEMENT_ANY, Role.ADMIN),
    BLOCKED_USERS_MANAGE(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    DISABLED_USERS_VIEW(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    DISABLED_USERS_MANAGE(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    REMOVED_USERS_VIEW(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    REMOVED_USERS_MANAGE(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    PURGED_USERS_VIEW(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    PURGED_USERS_MANAGE(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    USER_VISIBILITY_SEARCH(PermissionUserAccess.RELATIONSHIP_MEMBER, Role.MEMBER),
    USER_VISIBILITY_MAP_DIRECTORY(PermissionUserAccess.RELATIONSHIP_MEMBER, Role.basic()),
    USER_VISIBILITY_PROFILE(PermissionUserAccess.RELATIONSHIP_MEMBER, Role.MEMBER),
    MY_PRIVACY_SETTINGS_VIEW(PermissionUserAccess.MY, Role.basic()),
    MY_PRIVACY_SETTINGS_MANAGE(PermissionUserAccess.MY, Role.basic()),
    USER_PRIVACY_SETTINGS_VIEW(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    USER_PRIVACY_SETTINGS_MANAGE(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    USER_BROKER_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_BROKER_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_INVITE(PermissionUserAccess.NONE, Role.MEMBER, Role.ADMIN),
    MY_PASSWORDS_MANAGE(PermissionUserAccess.MY, Role.basic()),
    USER_PASSWORDS_MANAGE(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    MY_CHANNELS_ACCESS_ENABLE(PermissionUserAccess.MY, Role.basic()),
    USER_CHANNELS_ACCESS_VIEW(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    USER_CHANNELS_ACCESS_MANAGE(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    MY_AGREEMENT_LOG_VIEW(PermissionUserAccess.MY, Role.basic()),
    USER_AGREEMENT_LOG_VIEW(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    OIDC_CLIENTS_VIEW(Role.ADMIN),
    OIDC_CLIENTS_MANAGE(Role.ADMIN),
    MY_OIDC_AUTHORIZATIONS_ENABLE(PermissionUserAccess.MY, Role.basic()),
    USER_OIDC_AUTHORIZATIONS_VIEW(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    USER_OIDC_AUTHORIZATIONS_MANAGE(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    MY_IDENTITY_PROVIDERS_ENABLE(PermissionUserAccess.MY, Role.basic()),
    USER_IDENTITY_PROVIDERS_VIEW(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    USER_IDENTITY_PROVIDERS_MANAGE(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    PENDING_USERS_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    PENDING_USERS_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    CONNECTED_USERS_VIEW(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    CONNECTED_USERS_MANAGE(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    CONNECTED_USERS_LOGIN(PermissionUserAccess.MANAGEMENT_ANY, Role.ADMIN),
    PRODUCTS_ASSIGN_TO_USER(PermissionUserAccess.MANAGEMENT_ANY, Role.ADMIN),
    BULK_ACTIONS_VIEW(Role.ADMIN, Role.BROKER),
    BULK_ACTIONS_MANAGE(Role.ADMIN, Role.BROKER),
    MY_ACCOUNT_VISIBILITY_ENABLE(PermissionUserAccess.MY, Role.MEMBER),
    USER_ACCOUNT_VISIBILITY_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_ACCOUNT_VISIBILITY_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    SYSTEM_ACCOUNTS_VIEW(Role.ADMIN),
    USER_ACCOUNTS_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_ACCOUNT_LIMIT_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, PermissionAccountAccess.USER, Role.userManager()),
    USER_ACCOUNT_LIMIT_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_ACCOUNT_PAYMENT_LIMIT_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, PermissionAccountAccess.USER, Role.userManager()),
    USER_ACCOUNT_PAYMENT_LIMIT_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    ACCOUNT_FEE_LOGS_VIEW(Role.ADMIN),
    ACCOUNT_FEE_LOGS_MANAGE(Role.ADMIN),
    SYSTEM_PAYMENTS_PAY_TO_USER(PermissionUserAccess.RELATIONSHIP_MEMBER, PermissionAccountAccess.SYSTEM, Role.ADMIN),
    SYSTEM_PAYMENTS_PAY_TO_SYSTEM(PermissionAccountAccess.SYSTEM, Role.ADMIN),
    SYSTEM_PAYMENTS_CHARGEBACK(Role.ADMIN),
    MY_PAYMENTS_PAY_TO_SELF(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    MY_PAYMENTS_PAY_TO_SYSTEM(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    MY_PAYMENTS_PAY_TO_USER(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    MY_PAYMENTS_CHARGEBACK(PermissionUserAccess.MY, Role.MEMBER),
    MY_PAYMENTS_RECEIVE(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    USER_PAYMENTS_PAY_TO_SELF(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_PAYMENTS_PAY_TO_SYSTEM(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_PAYMENTS_PAY_TO_USER(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_PAYMENTS_CHARGEBACK(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    PAYMENTS_SET_BOOKING_DATE(Role.ADMIN),
    SYSTEM_PAYMENT_REQUESTS_VIEW(PermissionAccountAccess.SYSTEM, Role.ADMIN),
    SYSTEM_PAYMENT_REQUESTS_ACCEPT(PermissionAccountAccess.SYSTEM, Role.ADMIN),
    SYSTEM_PAYMENT_REQUESTS_CANCEL(PermissionAccountAccess.SYSTEM, Role.ADMIN),
    SYSTEM_PAYMENT_REQUESTS_SEND_TO_USER(PermissionAccountAccess.SYSTEM, Role.ADMIN),
    SYSTEM_PAYMENT_REQUESTS_CHANGE_EXPIRATION_DATE(PermissionAccountAccess.SYSTEM, Role.ADMIN),
    USER_PAYMENT_REQUESTS_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, PermissionAccountAccess.USER, Role.userManager()),
    USER_PAYMENT_REQUESTS_ACCEPT(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_PAYMENT_REQUESTS_CANCEL(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_PAYMENT_REQUESTS_SEND_TO_SYSTEM(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_PAYMENT_REQUESTS_SEND_TO_USER(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_PAYMENT_REQUESTS_CHANGE_EXPIRATION_DATE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    MY_PAYMENT_REQUESTS_VIEW(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    MY_PAYMENT_REQUESTS_ACCEPT(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    MY_PAYMENT_REQUESTS_CANCEL(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    MY_PAYMENT_REQUESTS_SEND_TO_SYSTEM(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    MY_PAYMENT_REQUESTS_SEND_TO_USER(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    MY_PAYMENT_REQUESTS_CHANGE_EXPIRATION_DATE(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    SYSTEM_AUTHORIZED_PAYMENTS_CANCEL(PermissionAccountAccess.SYSTEM, Role.ADMIN),
    ADMIN_AUTHORIZATIONS_MANAGE(PermissionAccountAccess.SYSTEM_OR_USER, Role.ADMIN),
    ADMIN_AUTHORIZATIONS_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, PermissionAccountAccess.SYSTEM_OR_USER, Role.ADMIN),
    MY_AUTHORIZED_PAYMENTS_VIEW(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    MY_AUTHORIZED_PAYMENTS_CANCEL(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    MY_AUTHORIZED_PAYMENTS_AUTHORIZE(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    USER_AUTHORIZED_PAYMENTS_CANCEL(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    BROKER_AUTHORIZED_PAYMENTS_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, PermissionAccountAccess.USER, Role.BROKER),
    BROKER_AUTHORIZED_PAYMENTS_AUTHORIZE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.BROKER),
    SYSTEM_SCHEDULED_PAYMENTS_VIEW(PermissionAccountAccess.SYSTEM, Role.ADMIN),
    SYSTEM_SCHEDULED_PAYMENTS_PROCESS_INSTALLMENT(PermissionAccountAccess.SYSTEM, Role.ADMIN),
    SYSTEM_SCHEDULED_PAYMENTS_SETTLE_INSTALLMENT(PermissionAccountAccess.SYSTEM, Role.ADMIN),
    SYSTEM_SCHEDULED_PAYMENTS_UNBLOCK(Role.ADMIN),
    SYSTEM_SCHEDULED_PAYMENTS_BLOCK(PermissionAccountAccess.SYSTEM, Role.ADMIN),
    SYSTEM_SCHEDULED_PAYMENTS_CANCEL(PermissionAccountAccess.SYSTEM, Role.ADMIN),
    SYSTEM_SCHEDULED_PAYMENTS_MODIFY(PermissionAccountAccess.SYSTEM, Role.ADMIN),
    MY_SCHEDULED_PAYMENTS_VIEW(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    MY_SCHEDULED_PAYMENTS_PROCESS_INSTALLMENT(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    MY_SCHEDULED_PAYMENTS_SETTLE_INSTALLMENT(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    MY_SCHEDULED_PAYMENTS_MODIFY(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    MY_SCHEDULED_PAYMENTS_UNBLOCK(PermissionUserAccess.MY, Role.MEMBER),
    MY_SCHEDULED_PAYMENTS_BLOCK(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    MY_SCHEDULED_PAYMENTS_CANCEL(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    USER_SCHEDULED_PAYMENTS_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, PermissionAccountAccess.USER, Role.userManager()),
    USER_SCHEDULED_PAYMENTS_PROCESS_INSTALLMENT(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_SCHEDULED_PAYMENTS_SETTLE_INSTALLMENT(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_SCHEDULED_PAYMENTS_MODIFY(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_SCHEDULED_PAYMENTS_UNBLOCK(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_SCHEDULED_PAYMENTS_BLOCK(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_SCHEDULED_PAYMENTS_CANCEL(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    MY_EXTERNAL_PAYMENTS_VIEW(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    USER_EXTERNAL_PAYMENTS_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, PermissionAccountAccess.USER, Role.userManager()),
    SYSTEM_EXTERNAL_PAYMENTS_VIEW(PermissionAccountAccess.SYSTEM, Role.ADMIN),
    MY_EXTERNAL_PAYMENTS_PAY_TO_USER(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    USER_EXTERNAL_PAYMENTS_PAY_TO_USER(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    SYSTEM_EXTERNAL_PAYMENTS_PAY_TO_USER(PermissionAccountAccess.SYSTEM, Role.ADMIN),
    MY_EXTERNAL_PAYMENTS_CANCEL(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    USER_EXTERNAL_PAYMENTS_CANCEL(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    SYSTEM_EXTERNAL_PAYMENTS_CANCEL(PermissionAccountAccess.SYSTEM, Role.ADMIN),
    MY_PAYMENT_TICKETS_APPROVE(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    MY_PAYMENT_TICKETS_CREATE(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    MY_PAYMENT_TICKETS_VIEW(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    MY_PAYMENT_TICKETS_CANCEL(PermissionUserAccess.MY, PermissionAccountAccess.MY, Role.MEMBER),
    USER_PAYMENT_TICKETS_CREATE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_PAYMENT_TICKETS_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_PAYMENT_TICKETS_CANCEL(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    MY_ADS_ENABLE(PermissionUserAccess.MY, Role.MEMBER),
    MY_ADS_MANAGE(PermissionUserAccess.MY, Role.MEMBER),
    USER_ADS_VIEW(PermissionUserAccess.MY_OR_RELATIONSHIP, Role.basic()),
    USER_ADS_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    MY_AD_QUESTIONS_ENABLE(PermissionUserAccess.MY, Role.MEMBER),
    USER_PENDING_ADS_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_PENDING_ADS_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    MY_FAVORITE_ADS_ENABLE(PermissionUserAccess.MY, Role.MEMBER),
    USER_FAVORITE_ADS_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    MY_WEB_SHOP_ENABLE(PermissionUserAccess.MY, Role.MEMBER),
    MY_WEB_SHOP_MANAGE(PermissionUserAccess.MY, Role.MEMBER),
    USER_WEB_SHOP_VIEW(PermissionUserAccess.MY_OR_RELATIONSHIP, Role.basic()),
    USER_WEB_SHOP_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    MY_WEB_SHOP_QUESTIONS_ENABLE(PermissionUserAccess.MY, Role.MEMBER),
    USER_WEB_SHOP_PURCHASE(PermissionUserAccess.MY_OR_RELATIONSHIP, Role.MEMBER),
    USER_WEB_SHOP_SETTINGS_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_WEB_SHOP_SETTINGS_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_WEB_SHOP_PURCHASES_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_WEB_SHOP_PURCHASES_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_WEB_SHOP_SALES_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_WEB_SHOP_SALES_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_PENDING_WEB_SHOP_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_PENDING_WEB_SHOP_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    MY_AD_INTERESTS_ENABLE(PermissionUserAccess.MY, Role.MEMBER),
    USER_AD_INTERESTS_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_AD_INTERESTS_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    DOCUMENTS_VIEW(Role.ADMIN, Role.BROKER),
    DOCUMENTS_MANAGE(Role.ADMIN),
    MY_SHARED_DOCUMENTS_VIEW(PermissionUserAccess.MY, Role.MEMBER),
    MY_INDIVIDUAL_DOCUMENTS_VIEW(PermissionUserAccess.MY, Role.MEMBER),
    USER_DOCUMENTS_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_DOCUMENTS_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    MY_OPERATORS_ENABLE(PermissionUserAccess.MY, Role.MEMBER),
    MY_OPERATORS_MANAGE_OPERATORS(PermissionUserAccess.MY, Role.MEMBER),
    MY_OPERATORS_MANAGE_GROUPS(PermissionUserAccess.MY, Role.MEMBER),
    USER_OPERATORS_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_OPERATORS_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_OPERATORS_PAY(PermissionUserAccess.RELATIONSHIP_MEMBER, Role.MEMBER),
    USER_CONTACT_INFO_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    MY_REFERENCES_VIEW(PermissionUserAccess.MY, Role.MEMBER),
    MY_REFERENCES_GIVE(PermissionUserAccess.MY, Role.MEMBER),
    MY_REFERENCES_RECEIVE(PermissionUserAccess.MY, Role.MEMBER),
    USER_REFERENCES_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    MY_TRANSACTION_FEEDBACKS_VIEW(PermissionUserAccess.MY, Role.MEMBER),
    MY_TRANSACTION_FEEDBACKS_GIVE(PermissionUserAccess.MY, Role.MEMBER),
    MY_TRANSACTION_FEEDBACKS_RECEIVE(PermissionUserAccess.MY, Role.MEMBER),
    USER_TRANSACTION_FEEDBACKS_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    SYSTEM_MESSAGES_VIEW(Role.ADMIN),
    SYSTEM_MESSAGES_MANAGE(Role.ADMIN),
    SYSTEM_MESSAGES_SEND_TO_USER(Role.ADMIN),
    SYSTEM_MESSAGES_SEND_TO_GROUPS(Role.ADMIN),
    MY_MESSAGES_VIEW(PermissionUserAccess.MY, Role.MEMBER),
    MY_MESSAGES_SEND_TO_USER(PermissionUserAccess.MY, Role.MEMBER),
    MY_MESSAGES_SEND_TO_SYSTEM(PermissionUserAccess.MY, Role.MEMBER),
    MY_MESSAGES_SEND_TO_BROKERED_USERS(PermissionUserAccess.MY, Role.BROKER),
    MY_MESSAGES_FORWARD_TO_EMAIL(PermissionUserAccess.MY, Role.MEMBER),
    MAILINGS_VIEW(Role.ADMIN, Role.BROKER),
    MAILINGS_MANAGE(Role.ADMIN, Role.BROKER),
    SYSTEM_REPORTS_VIEW(Role.ADMIN),
    SYSTEM_REPORTS_MANAGE(Role.ADMIN),
    MY_NOTIFICATIONS_ENABLE(PermissionUserAccess.MY, Role.MEMBER, Role.ADMIN),
    MY_NOTIFICATION_SETTINGS_ENABLE(PermissionUserAccess.MY, Role.MEMBER, Role.ADMIN),
    USER_NOTIFICATION_SETTINGS_VIEW(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    USER_NOTIFICATION_SETTINGS_MANAGE(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    MY_CONTACTS_ENABLE(PermissionUserAccess.MY, Role.MEMBER, Role.ADMIN),
    USER_CONTACTS_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_CONTACTS_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    MY_QUICK_ACCESS_SETTINGS_ENABLE(PermissionUserAccess.MY, Role.basic()),
    USER_QUICK_ACCESS_SETTINGS_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_QUICK_ACCESS_SETTINGS_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    SYSTEM_CUSTOM_IMAGES_VIEW(Role.ADMIN),
    SYSTEM_CUSTOM_IMAGES_MANAGE(Role.ADMIN),
    MY_CUSTOM_IMAGES_ENABLE(PermissionUserAccess.MY, Role.MEMBER),
    USER_CUSTOM_IMAGES_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    VOUCHER_TYPES_VIEW(Role.ADMIN),
    VOUCHER_TYPES_MANAGE(Role.ADMIN),
    VOUCHER_TEMPLATES_VIEW(Role.ADMIN),
    VOUCHER_TEMPLATES_MANAGE(Role.ADMIN),
    VOUCHERS_VIEW(Role.ADMIN),
    VOUCHERS_GENERATE(Role.ADMIN),
    MY_VOUCHERS_VIEW_VOUCHERS(PermissionUserAccess.MY, Role.MEMBER),
    MY_VOUCHERS_BUY(PermissionUserAccess.MY, Role.MEMBER),
    MY_VOUCHERS_SEND(PermissionUserAccess.MY, Role.MEMBER),
    MY_VOUCHERS_BATCH_SEND(PermissionUserAccess.MY, Role.MEMBER),
    MY_VOUCHERS_VIEW_TRANSACTIONS(PermissionUserAccess.MY, Role.MEMBER),
    MY_VOUCHERS_REDEEM(PermissionUserAccess.MY, Role.MEMBER),
    MY_VOUCHERS_TOP_UP(PermissionUserAccess.MY, Role.MEMBER),
    USER_VOUCHERS_VIEW_VOUCHERS(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_VOUCHERS_BUY(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_VOUCHERS_SEND(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_VOUCHERS_BATCH_SEND_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_VOUCHERS_BATCH_SEND_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_VOUCHERS_VIEW_TRANSACTIONS(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_VOUCHERS_REDEEM(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_VOUCHERS_TOP_UP(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_TRUSTED_DEVICES_VIEW(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    USER_TRUSTED_DEVICES_MANAGE(PermissionUserAccess.MANAGEMENT_ANY, Role.userManager()),
    USER_PINS_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_PINS_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_TOTP_VIEW(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager()),
    USER_TOTP_MANAGE(PermissionUserAccess.MANAGEMENT_MEMBER, Role.userManager());

    private final PermissionUserAccess userAccess;
    private final PermissionAccountAccess accountAccess;
    private final List<Role> roles;

    private Permission(PermissionAccountAccess permissionAccountAccess, Role ... roleArray) {
        this(PermissionUserAccess.NONE, permissionAccountAccess, roleArray);
    }

    private Permission(PermissionUserAccess permissionUserAccess, PermissionAccountAccess permissionAccountAccess, Role ... roleArray) {
        this.userAccess = permissionUserAccess;
        List<Role> list = Arrays.asList(roleArray);
        if (list.contains(Role.MEMBER)) {
            ArrayList<Role> arrayList = new ArrayList<Role>(list);
            arrayList.add(Role.BROKER);
            list = arrayList;
        }
        this.roles = Collections.unmodifiableList(list);
        this.accountAccess = permissionAccountAccess;
    }

    private Permission(PermissionUserAccess permissionUserAccess, Role ... roleArray) {
        this(permissionUserAccess, (PermissionAccountAccess)null, roleArray);
    }

    private Permission(Role ... roleArray) {
        this(PermissionUserAccess.NONE, roleArray);
    }

    public PermissionAccountAccess getAccountAccess() {
        return this.accountAccess;
    }

    public Collection<Role> getRoles() {
        return this.roles;
    }

    public PermissionUserAccess getUserAccess() {
        return this.userAccess;
    }
}

