/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.access;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.BusinessException;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.CredentialType;
import org.cyclos.model.access.devices.InvalidDeviceConfirmationResult;
import org.cyclos.model.access.passwords.PasswordStatus;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.MessageProducer;

public class LoginException
extends BusinessException {
    private static final long serialVersionUID = 1L;
    private PasswordStatus passwordStatus;
    private UserStatus userStatus;
    private PasswordTypeVO missingLoginConfirmationPasswordType;
    private Set<CredentialType> missingLoginConfirmationCredentials;
    private InvalidDeviceConfirmationResult invalidDeviceConfirmationResult;

    public LoginException() {
    }

    public LoginException(InvalidDeviceConfirmationResult invalidDeviceConfirmationResult) {
        this.invalidDeviceConfirmationResult = invalidDeviceConfirmationResult;
    }

    public LoginException(PasswordStatus passwordStatus) {
        this.passwordStatus = passwordStatus;
    }

    public LoginException(Set<CredentialType> set, PasswordTypeVO passwordTypeVO) {
        this.missingLoginConfirmationCredentials = set;
        this.missingLoginConfirmationPasswordType = passwordTypeVO;
    }

    public LoginException(String string) {
        super(string);
    }

    public LoginException(UserStatus userStatus) {
        this.userStatus = userStatus;
    }

    public InvalidDeviceConfirmationResult getInvalidDeviceConfirmationResult() {
        return this.invalidDeviceConfirmationResult;
    }

    public Set<CredentialType> getMissingLoginConfirmationCredentials() {
        return this.missingLoginConfirmationCredentials;
    }

    public PasswordTypeVO getMissingLoginConfirmationPasswordType() {
        return this.missingLoginConfirmationPasswordType;
    }

    public PasswordStatus getPasswordStatus() {
        return this.passwordStatus;
    }

    public UserStatus getUserStatus() {
        return this.userStatus;
    }

    public void setInvalidDeviceConfirmationResult(InvalidDeviceConfirmationResult invalidDeviceConfirmationResult) {
        this.invalidDeviceConfirmationResult = invalidDeviceConfirmationResult;
    }

    public void setMissingLoginConfirmationCredentials(Set<CredentialType> set) {
        this.missingLoginConfirmationCredentials = set;
    }

    public void setMissingLoginConfirmationPasswordType(PasswordTypeVO passwordTypeVO) {
        this.missingLoginConfirmationPasswordType = passwordTypeVO;
    }

    public void setPasswordStatus(PasswordStatus passwordStatus) {
        this.passwordStatus = passwordStatus;
    }

    public void setUserStatus(UserStatus userStatus) {
        this.userStatus = userStatus;
    }

    public String translate(MessageProducer messageProducer) {
        PasswordStatus passwordStatus = this.getPasswordStatus();
        UserStatus userStatus = this.getUserStatus();
        if (CollectionHelper.isNotEmpty(this.missingLoginConfirmationCredentials)) {
            if (this.missingLoginConfirmationCredentials.size() == 1) {
                if (this.missingLoginConfirmationCredentials.contains(CredentialType.PASSWORD)) {
                    return messageProducer.message(AccessKeys.Login.ERROR_MISSING_LOGIN_CONFIRMATION_CREDENTIAL_PASSWORD, new Object[]{this.getMissingLoginConfirmationPasswordType()});
                }
                if (this.missingLoginConfirmationCredentials.contains(CredentialType.DEVICE)) {
                    return messageProducer.message(AccessKeys.Login.ERROR_MISSING_LOGIN_CONFIRMATION_CREDENTIAL_DEVICE, new Object[0]);
                }
            }
            List list = this.missingLoginConfirmationCredentials.stream().map(credentialType -> credentialType == CredentialType.PASSWORD ? this.getMissingLoginConfirmationPasswordType() : credentialType).collect(Collectors.toList());
            return messageProducer.message(AccessKeys.Login.ERROR_MISSING_LOGIN_CONFIRMATION_CREDENTIAL, list);
        }
        if (passwordStatus != null) {
            MessageKey messageKey;
            switch (passwordStatus) {
                case TEMPORARILY_BLOCKED: {
                    messageKey = AccessKeys.Login.ERROR_PASSWORD_TEMPORARILY_BLOCKED;
                    break;
                }
                case INDEFINITELY_BLOCKED: {
                    messageKey = AccessKeys.Login.ERROR_PASSWORD_INDEFINITELY_BLOCKED;
                    break;
                }
                case DISABLED: {
                    messageKey = AccessKeys.Login.ERROR_PASSWORD_DISABLED;
                    break;
                }
                case EXPIRED: {
                    messageKey = AccessKeys.Login.ERROR_PASSWORD_EXPIRED;
                    break;
                }
                case RESET: {
                    messageKey = AccessKeys.Login.ERROR_PASSWORD_RESET;
                    break;
                }
                default: {
                    messageKey = AccessKeys.Login.ERROR_INVALID;
                }
            }
            return messageProducer.message(messageKey, new Object[0]);
        }
        if (userStatus != null) {
            MessageKey messageKey;
            switch (userStatus) {
                case BLOCKED: {
                    messageKey = AccessKeys.Login.ERROR_USER_BLOCKED;
                    break;
                }
                case DISABLED: {
                    messageKey = AccessKeys.Login.ERROR_USER_DISABLED;
                    break;
                }
                case PENDING: {
                    messageKey = AccessKeys.Login.ERROR_USER_PENDING;
                    break;
                }
                default: {
                    messageKey = AccessKeys.Login.ERROR_INVALID;
                }
            }
            return messageProducer.message(messageKey, new Object[0]);
        }
        return messageProducer.message(AccessKeys.Login.ERROR_INVALID, new Object[0]);
    }
}

